/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.tournament.services.TournamentPlatformHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/valkyrienskies/tournament/TournamentModels;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "rl", "Lnet/minecraft/client/resources/model/BakedModel;", "getModel", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/resources/model/BakedModel;", "", "name", "Lorg/valkyrienskies/tournament/TournamentModels$Model;", "model", "(Ljava/lang/String;)Lorg/valkyrienskies/tournament/TournamentModels$Model;", "", "MODELS", "Ljava/util/Set;", "getMODELS", "()Ljava/util/Set;", "PROP_BIG", "Lorg/valkyrienskies/tournament/TournamentModels$Model;", "getPROP_BIG", "()Lorg/valkyrienskies/tournament/TournamentModels$Model;", "PROP_SMALL", "getPROP_SMALL", "Model", "Renderer", "tournament"})
public final class TournamentModels {
    @NotNull
    public static final TournamentModels INSTANCE = new TournamentModels();
    @NotNull
    private static final Set<ResourceLocation> MODELS = new LinkedHashSet();
    @NotNull
    private static final Model PROP_BIG = INSTANCE.model("block/prop_big_prop");
    @NotNull
    private static final Model PROP_SMALL = INSTANCE.model("block/prop_small_prop");

    private TournamentModels() {
    }

    private final BakedModel getModel(ResourceLocation rl) {
        BakedModel model = TournamentPlatformHelper.Companion.get().loadBakedModel(rl);
        if (model == null) {
            System.out.println((Object)("[Tournament] Failed to load model " + rl));
            BakedModel bakedModel2 = Minecraft.m_91087_().m_91304_().m_119409_();
            Intrinsics.checkNotNullExpressionValue((Object)bakedModel2, (String)"getMissingModel(...)");
            return bakedModel2;
        }
        return model;
    }

    @NotNull
    public final Set<ResourceLocation> getMODELS() {
        return MODELS;
    }

    private final Model model(String name) {
        ResourceLocation rl = new ResourceLocation("vs_tournament", name);
        ((Collection)MODELS).add(rl);
        return new Model(rl);
    }

    @NotNull
    public final Model getPROP_BIG() {
        return PROP_BIG;
    }

    @NotNull
    public final Model getPROP_SMALL() {
        return PROP_SMALL;
    }

    public static final /* synthetic */ BakedModel access$getModel(TournamentModels $this, ResourceLocation rl) {
        return $this.getModel(rl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0019\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u0007\u00a8\u0006!"}, d2={"Lorg/valkyrienskies/tournament/TournamentModels$Model;", "", "Lnet/minecraft/resources/ResourceLocation;", "resourceLocation", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "copy", "(Lnet/minecraft/resources/ResourceLocation;)Lorg/valkyrienskies/tournament/TournamentModels$Model;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/client/resources/model/BakedModel;", "bakedModel$delegate", "Lkotlin/Lazy;", "getBakedModel", "()Lnet/minecraft/client/resources/model/BakedModel;", "bakedModel", "Lorg/valkyrienskies/tournament/TournamentModels$Renderer;", "renderer", "Lorg/valkyrienskies/tournament/TournamentModels$Renderer;", "getRenderer", "()Lorg/valkyrienskies/tournament/TournamentModels$Renderer;", "Lnet/minecraft/resources/ResourceLocation;", "getResourceLocation", "tournament"})
    public static final class Model {
        @NotNull
        private final ResourceLocation resourceLocation;
        @NotNull
        private final Lazy bakedModel$delegate;
        @NotNull
        private final Renderer renderer;

        public Model(@NotNull ResourceLocation resourceLocation) {
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
            this.resourceLocation = resourceLocation;
            this.bakedModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BakedModel>(this){
                final /* synthetic */ Model this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final BakedModel invoke() {
                    return TournamentModels.access$getModel(TournamentModels.INSTANCE, this.this$0.getResourceLocation());
                }
            }));
            this.renderer = new Renderer(this){
                final /* synthetic */ Model this$0;
                {
                    this.this$0 = $receiver;
                }

                public void render(@NotNull PoseStack matrixStack, @NotNull BlockEntity blockEntity, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
                    Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                    Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
                    Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
                    Level level = blockEntity.m_58904_();
                    if (level == null) {
                        return;
                    }
                    Level level2 = level;
                    Minecraft.m_91087_().m_91289_().m_110937_().m_234401_((BlockAndTintGetter)level2, this.this$0.getBakedModel(), blockEntity.m_58900_(), blockEntity.m_58899_(), matrixStack, bufferSource.m_6299_(RenderType.m_110463_()), true, level2.f_46441_, 42L, packedOverlay);
                }
            };
        }

        @NotNull
        public final ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        @NotNull
        public final BakedModel getBakedModel() {
            Lazy lazy = this.bakedModel$delegate;
            return (BakedModel)lazy.getValue();
        }

        @NotNull
        public final Renderer getRenderer() {
            return this.renderer;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.resourceLocation;
        }

        @NotNull
        public final Model copy(@NotNull ResourceLocation resourceLocation) {
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
            return new Model(resourceLocation);
        }

        public static /* synthetic */ Model copy$default(Model model, ResourceLocation resourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = model.resourceLocation;
            }
            return model.copy(resourceLocation);
        }

        @NotNull
        public String toString() {
            return "Model(resourceLocation=" + this.resourceLocation + ")";
        }

        public int hashCode() {
            return this.resourceLocation.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model = (Model)other;
            return Intrinsics.areEqual((Object)this.resourceLocation, (Object)model.resourceLocation);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J7\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH&\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/valkyrienskies/tournament/TournamentModels$Renderer;", "", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrixStack", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockEntity", "Lnet/minecraft/client/renderer/MultiBufferSource;", "bufferSource", "", "packedLight", "packedOverlay", "", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "tournament"})
    public static interface Renderer {
        public void render(@NotNull PoseStack var1, @NotNull BlockEntity var2, @NotNull MultiBufferSource var3, int var4, int var5);
    }
}

