/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blockentity;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.tournament.TournamentBlockEntities;
import org.valkyrienskies.tournament.chunk.ChunkLoader;
import org.valkyrienskies.tournament.chunk.ChunkLoaderManager;
import org.valkyrienskies.tournament.chunk.ChunkLoadingTicket;
import org.valkyrienskies.tournament.util.extension.VectorExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/valkyrienskies/tournament/blockentity/ChunkLoaderBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lorg/valkyrienskies/tournament/chunk/ChunkLoader;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lorg/joml/Vector3d;", "getCurrPos", "()Lorg/joml/Vector3d;", "Lnet/minecraft/world/level/ChunkPos;", "getCurrentChunk", "()Lnet/minecraft/world/level/ChunkPos;", "getFutureChunk", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;", "ticket", "Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;", "getTicket$tournament", "()Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;", "setTicket$tournament", "(Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;)V", "Companion", "tournament"})
public final class ChunkLoaderBlockEntity
extends BlockEntity
implements ChunkLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ChunkLoadingTicket ticket;
    @NotNull
    private static final BlockEntityTicker<ChunkLoaderBlockEntity> ticker = ChunkLoaderBlockEntity::ticker$lambda$0;

    public ChunkLoaderBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(TournamentBlockEntities.INSTANCE.getCHUNK_LOADER().get(), pos, state);
    }

    @Nullable
    public final ChunkLoadingTicket getTicket$tournament() {
        return this.ticket;
    }

    public final void setTicket$tournament(@Nullable ChunkLoadingTicket chunkLoadingTicket) {
        this.ticket = chunkLoadingTicket;
    }

    public final void tick(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.ticket == null) {
            ChunkLoaderManager manager = ChunkLoaderManager.Companion.getFor(level);
            this.ticket = manager.allocate(this, 200);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Vector3d getCurrPos() {
        Level level = this.f_58857_;
        if (level == null) return null;
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        LoadedShip loadedShip = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)((Vec3i)blockPos));
        if (loadedShip == null) return null;
        Matrix4dc matrix4dc = loadedShip.getShipToWorld();
        if (matrix4dc == null) return null;
        BlockPos blockPos2 = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        Vector3d vector3d = matrix4dc.transformPosition(VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2)));
        return vector3d;
    }

    @Override
    @NotNull
    public ChunkPos getCurrentChunk() {
        ChunkPos chunkPos;
        ChunkPos chunkPos2;
        Vector3d vector3d = this.getCurrPos();
        if (vector3d != null && (chunkPos2 = VectorExtensionsKt.toChunkPos(vector3d)) != null) {
            chunkPos = chunkPos2;
        } else {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            chunkPos = VectorExtensionsKt.toChunkPos(blockPos);
        }
        return chunkPos;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChunkPos getFutureChunk() {
        ChunkPos chunkPos;
        Level level = this.f_58857_;
        if (level != null) {
            ChunkPos chunkPos2;
            Vector3d vector3d;
            Vector3d vector3d2;
            Vector3dc vector3dc;
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            LoadedShip loadedShip = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)((Vec3i)blockPos));
            if (loadedShip != null && (vector3dc = loadedShip.getVelocity()) != null && (vector3d2 = vector3dc.mul(3.0, new Vector3d())) != null && (vector3d = vector3d2.add((Vector3dc)this.getCurrPos())) != null && (chunkPos2 = VectorExtensionsKt.toChunkPos(vector3d)) != null) {
                chunkPos = chunkPos2;
                return chunkPos;
            }
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        chunkPos = VectorExtensionsKt.toChunkPos(blockPos);
        return chunkPos;
    }

    @Override
    public void getChunksToLoad(@NotNull List<ChunkPos> destination) {
        ChunkLoader.DefaultImpls.getChunksToLoad(this, destination);
    }

    private static final void ticker$lambda$0(Level level, BlockPos blockPos, BlockState blockState, ChunkLoaderBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        be.tick((ServerLevel)level);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/tournament/blockentity/ChunkLoaderBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lorg/valkyrienskies/tournament/blockentity/ChunkLoaderBlockEntity;", "ticker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "tournament"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<ChunkLoaderBlockEntity> getTicker() {
            return ticker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

