/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blockentity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.tournament.blocks.PropellerBlock;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\b&\u0018\u0000 4*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u00014B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000b\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001f\u001a\u0004\b\"\u0010!R\"\u0010$\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010+\u001a\u00020*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u00101\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010%\u001a\u0004\b2\u0010'\"\u0004\b3\u0010)\u00a8\u00065"}, d2={"Lorg/valkyrienskies/tournament/blockentity/PropellerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "be", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "maxSpeed", "accel", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;FF)V", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "Lnet/minecraft/nbt/CompoundTag;", "getUpdateTag", "()Lnet/minecraft/nbt/CompoundTag;", "tag", "", "load", "(Lnet/minecraft/nbt/CompoundTag;)V", "saveAdditional", "Lnet/minecraft/world/level/Level;", "level", "tick", "(Lnet/minecraft/world/level/Level;)V", "update", "()V", "F", "getAccel", "()F", "getMaxSpeed", "", "rotation", "D", "getRotation", "()D", "setRotation", "(D)V", "", "signal", "I", "getSignal", "()I", "setSignal", "(I)V", "speed", "getSpeed", "setSpeed", "Companion", "tournament"})
public abstract class PropellerBlockEntity<T extends BlockEntity>
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float maxSpeed;
    private final float accel;
    private int signal;
    private double rotation;
    private double speed;
    @NotNull
    private static final BlockEntityTicker<PropellerBlockEntity<?>> ticker = PropellerBlockEntity::ticker$lambda$1;

    public PropellerBlockEntity(@NotNull BlockEntityType<T> be, @NotNull BlockPos pos, @NotNull BlockState state, float maxSpeed, float accel) {
        Intrinsics.checkNotNullParameter(be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(be, pos, state);
        this.maxSpeed = maxSpeed;
        this.accel = accel;
        this.signal = -1;
    }

    public final float getMaxSpeed() {
        return this.maxSpeed;
    }

    public final float getAccel() {
        return this.accel;
    }

    public final int getSignal() {
        return this.signal;
    }

    public final void setSignal(int n) {
        this.signal = n;
    }

    public final double getRotation() {
        return this.rotation;
    }

    public final void setRotation(double d) {
        this.rotation = d;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public final void tick(@NotNull Level level) {
        float targetSpeed;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.signal == -1) {
            BlockState blockState = this.m_58900_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.signal = PropellerBlock.Companion.getPropSignal(blockState, level, blockPos);
        }
        if (this.speed < (double)(targetSpeed = (float)this.signal / 15.0f * this.maxSpeed)) {
            this.speed += (double)this.accel;
        } else if (this.speed > (double)targetSpeed) {
            this.speed -= (double)(this.accel * (float)2);
        }
        if (this.speed < 0.0) {
            this.speed = 0.0;
        }
        this.rotation -= this.speed;
        this.rotation %= 360.0;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag;
        CompoundTag it = compoundTag = new CompoundTag();
        boolean bl = false;
        this.m_183515_(it);
        return compoundTag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128347_("speed", this.speed);
        tag.m_128347_("rotation", this.rotation);
        tag.m_128405_("signal", this.signal);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.speed = tag.m_128459_("speed");
        this.rotation = tag.m_128459_("rotation");
        this.signal = tag.m_128451_("signal");
        super.m_142466_(tag);
    }

    public final void update() {
        block0: {
            Level level = this.f_58857_;
            if (level == null) break block0;
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
        }
    }

    private static final void ticker$lambda$1(Level level, BlockPos blockPos, BlockState blockState, PropellerBlockEntity be) {
        Intrinsics.checkNotNull((Object)level);
        be.tick(level);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/tournament/blockentity/PropellerBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lorg/valkyrienskies/tournament/blockentity/PropellerBlockEntity;", "ticker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "tournament"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<PropellerBlockEntity<?>> getTicker() {
            return ticker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

