/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blockentity;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.tournament.TournamentBlockEntities;
import org.valkyrienskies.tournament.TournamentConfig;
import org.valkyrienskies.tournament.TournamentDebugHelper;
import org.valkyrienskies.tournament.util.debug.DebugLine;
import org.valkyrienskies.tournament.util.helper.Helper3d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0011J5\u0010\u001b\u001a\u00020\u000f2\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u001fR\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010-\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b-\u0010/\"\u0004\b\u001e\u00100R$\u00101\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\"\u00108\u001a\u0002078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R$\u0010>\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u00102\u001a\u0004\b?\u00104\"\u0004\b@\u00106R*\u0010A\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010F\u00a8\u0006G"}, d2={"Lorg/valkyrienskies/tournament/blockentity/RopeHookBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "Lnet/minecraft/nbt/CompoundTag;", "getUpdateTag", "()Lnet/minecraft/nbt/CompoundTag;", "tag", "", "load", "(Lnet/minecraft/nbt/CompoundTag;)V", "saveAdditional", "", "Lorg/valkyrienskies/physics_api/ConstraintId;", "rope", "Lorg/joml/Vector3d;", "mainIn", "otherIn", "Lnet/minecraft/world/level/Level;", "level", "setRopeID", "(ILorg/joml/Vector3d;Lorg/joml/Vector3d;Lnet/minecraft/world/level/Level;)V", "main", "setSecondary", "(Lnet/minecraft/core/BlockPos;)V", "conPos", "Lnet/minecraft/core/BlockPos;", "getConPos", "()Lnet/minecraft/core/BlockPos;", "setConPos", "", "debugID", "J", "getDebugID", "()J", "setDebugID", "(J)V", "", "isSecondary", "Z", "()Z", "(Z)V", "mainPos", "Lorg/joml/Vector3d;", "getMainPos", "()Lorg/joml/Vector3d;", "setMainPos", "(Lorg/joml/Vector3d;)V", "", "maxLen", "D", "getMaxLen", "()D", "setMaxLen", "(D)V", "otherPos", "getOtherPos", "setOtherPos", "ropeId", "Ljava/lang/Integer;", "getRopeId", "()Ljava/lang/Integer;", "setRopeId", "(Ljava/lang/Integer;)V", "tournament"})
public final class RopeHookBlockEntity
extends BlockEntity {
    @Nullable
    private Integer ropeId;
    @Nullable
    private Vector3d mainPos;
    @Nullable
    private Vector3d otherPos;
    private double maxLen;
    private long debugID;
    private boolean isSecondary;
    @Nullable
    private BlockPos conPos;

    public RopeHookBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(TournamentBlockEntities.INSTANCE.getROPE_HOOK().get(), pos, state);
        this.debugID = -1L;
    }

    @Nullable
    public final Integer getRopeId() {
        return this.ropeId;
    }

    public final void setRopeId(@Nullable Integer n) {
        this.ropeId = n;
    }

    @Nullable
    public final Vector3d getMainPos() {
        return this.mainPos;
    }

    public final void setMainPos(@Nullable Vector3d vector3d) {
        this.mainPos = vector3d;
    }

    @Nullable
    public final Vector3d getOtherPos() {
        return this.otherPos;
    }

    public final void setOtherPos(@Nullable Vector3d vector3d) {
        this.otherPos = vector3d;
    }

    public final double getMaxLen() {
        return this.maxLen;
    }

    public final void setMaxLen(double d) {
        this.maxLen = d;
    }

    public final long getDebugID() {
        return this.debugID;
    }

    public final void setDebugID(long l) {
        this.debugID = l;
    }

    public final boolean isSecondary() {
        return this.isSecondary;
    }

    public final void setSecondary(boolean bl) {
        this.isSecondary = bl;
    }

    @Nullable
    public final BlockPos getConPos() {
        return this.conPos;
    }

    public final void setConPos(@Nullable BlockPos blockPos) {
        this.conPos = blockPos;
    }

    public final void setRopeID(int rope, @Nullable Vector3d mainIn, @Nullable Vector3d otherIn, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        System.out.println((Object)("Block>> " + rope));
        Vector3d vector3d = mainIn;
        Intrinsics.checkNotNull((Object)vector3d);
        Vector3d vector3d2 = vector3d.add(0.5, 0.5, 0.5, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
        Vector3d main = Helper3d.INSTANCE.convertShipToWorldSpace(level, vector3d2);
        Vector3d vector3d3 = otherIn;
        Intrinsics.checkNotNull((Object)vector3d3);
        Vector3d vector3d4 = vector3d3.add(0.5, 0.5, 0.5, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"add(...)");
        Vector3d other = Helper3d.INSTANCE.convertShipToWorldSpace(level, vector3d4);
        this.ropeId = rope;
        this.otherPos = other;
        this.mainPos = main;
        this.maxLen = 0.0;
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RED");
        this.debugID = TournamentDebugHelper.Companion.addObject(new DebugLine(main, other, color, !TournamentConfig.CLIENT.getParticleRopeRenderer()));
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
    }

    public final void setSecondary(@NotNull BlockPos main) {
        Intrinsics.checkNotNullParameter((Object)main, (String)"main");
        System.out.println((Object)("set secondary " + main));
        this.isSecondary = true;
        this.conPos = main;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (this.mainPos == null || this.otherPos == null) {
            return;
        }
        Vector3d vector3d = this.mainPos;
        Intrinsics.checkNotNull((Object)vector3d);
        tag.m_128347_("mainX", vector3d.x);
        Vector3d vector3d2 = this.mainPos;
        Intrinsics.checkNotNull((Object)vector3d2);
        tag.m_128347_("mainY", vector3d2.y);
        Vector3d vector3d3 = this.mainPos;
        Intrinsics.checkNotNull((Object)vector3d3);
        tag.m_128347_("mainZ", vector3d3.z);
        Vector3d vector3d4 = this.otherPos;
        Intrinsics.checkNotNull((Object)vector3d4);
        tag.m_128347_("otherX", vector3d4.x);
        Vector3d vector3d5 = this.otherPos;
        Intrinsics.checkNotNull((Object)vector3d5);
        tag.m_128347_("otherY", vector3d5.y);
        Vector3d vector3d6 = this.otherPos;
        Intrinsics.checkNotNull((Object)vector3d6);
        tag.m_128347_("otherZ", vector3d6.z);
        tag.m_128347_("maxLen", this.maxLen);
        tag.m_128356_("debugID", this.debugID);
        System.out.println((Object)("saved debugID: " + this.debugID));
        Integer n = this.ropeId;
        Intrinsics.checkNotNull((Object)n);
        tag.m_128405_("ropeId", n.intValue());
        tag.m_128379_("secondary", this.isSecondary);
        if (this.isSecondary) {
            System.out.println((Object)"saved: secondary");
            BlockPos blockPos = this.conPos;
            Intrinsics.checkNotNull((Object)blockPos);
            tag.m_128405_("conX", blockPos.m_123341_());
            BlockPos blockPos2 = this.conPos;
            Intrinsics.checkNotNull((Object)blockPos2);
            tag.m_128405_("conY", blockPos2.m_123342_());
            BlockPos blockPos3 = this.conPos;
            Intrinsics.checkNotNull((Object)blockPos3);
            tag.m_128405_("conZ", blockPos3.m_123343_());
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.mainPos = new Vector3d(tag.m_128459_("mainX"), tag.m_128459_("mainY"), tag.m_128459_("mainZ"));
        this.otherPos = new Vector3d(tag.m_128459_("otherX"), tag.m_128459_("otherY"), tag.m_128459_("otherZ"));
        this.maxLen = tag.m_128459_("maxLen");
        this.debugID = tag.m_128454_("debugID");
        this.ropeId = tag.m_128451_("ropeId");
        this.isSecondary = tag.m_128471_("secondary");
        if (this.isSecondary) {
            System.out.println((Object)"loaded secondary");
            this.conPos = new BlockPos(tag.m_128451_("conX"), tag.m_128451_("conY"), tag.m_128451_("conZ"));
        }
    }
}

