/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blockentity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import org.valkyrienskies.tournament.TournamentBlockEntities;
import org.valkyrienskies.tournament.TournamentConfig;
import org.valkyrienskies.tournament.util.helper.Helper3d;
import org.valkyrienskies.tournament.util.math.LerpKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/tournament/blockentity/SensorBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "getResult", "(Lnet/minecraft/server/level/ServerLevel;)I", "lastVal", "I", "getLastVal", "()I", "setLastVal", "(I)V", "Companion", "tournament"})
public final class SensorBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int lastVal;

    public SensorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(TournamentBlockEntities.INSTANCE.getSENSOR().get(), pos, state);
    }

    public final int getLastVal() {
        return this.lastVal;
    }

    public final void setLastVal(int n) {
        this.lastVal = n;
    }

    public final int getResult(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Vec3i facing = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        Level level2 = (Level)level;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)this.m_58899_())).m_82549_(Vec3.m_82528_((Vec3i)facing).m_82490_(0.5));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        Vector3d start = Helper3d.INSTANCE.convertShipToWorldSpace(level2, vec3);
        Level level3 = (Level)level;
        Vec3 vec32 = Vec3.m_82512_((Vec3i)((Vec3i)this.m_58899_())).m_82549_(Vec3.m_82528_((Vec3i)facing).m_82490_(TournamentConfig.SERVER.getSensorDistance() + 0.5));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        Vector3d end = Helper3d.INSTANCE.convertShipToWorldSpace(level3, vec32);
        BlockHitResult clipResult = RaycastUtilsKt.clipIncludeShips$default((Level)((Level)level), (ClipContext)new ClipContext(VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)start)), VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)end)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null), (boolean)true, null, (int)4, null);
        Level level4 = (Level)level;
        Vec3 vec33 = clipResult.m_82450_();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getLocation(...)");
        Vector3d hit = Helper3d.INSTANCE.convertShipToWorldSpace(level4, VectorConversionsMCKt.toJOML((Vec3)vec33));
        return clipResult.m_6662_() != HitResult.Type.MISS ? (int)Math.ceil(LerpKt.lerp(15.0, 1.0, start.distance((Vector3dc)hit) / TournamentConfig.SERVER.getSensorDistance())) : 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/tournament/blockentity/SensorBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "be", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "tournament"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity be) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            SensorBlockEntity cfr_ignored_0 = (SensorBlockEntity)be;
            if (level.f_46443_) {
                return;
            }
            ((SensorBlockEntity)be).setLastVal(((SensorBlockEntity)be).getResult((ServerLevel)level));
            Integer n = (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_);
            if (n != null && ((SensorBlockEntity)be).getLastVal() == n.intValue()) {
                return;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(((SensorBlockEntity)be).getLastVal())), 2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

