/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blocks;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.tournament.TournamentConfig;
import org.valkyrienskies.tournament.TournamentLootTables;
import org.valkyrienskies.tournament.TournamentTriggers;
import org.valkyrienskies.tournament.ship.TournamentShips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J7\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\"\u0010\u001a\u00a8\u0006#"}, d2={"Lorg/valkyrienskies/tournament/blocks/BalloonBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/entity/Entity;", "entity", "", "f", "", "fallOn", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;F)V", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lorg/valkyrienskies/tournament/ship/TournamentShips;", "getShipControl", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Lorg/valkyrienskies/tournament/ship/TournamentShips;", "oldState", "", "isMoving", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/entity/projectile/Projectile;", "projectile", "onProjectileHit", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/BlockHitResult;Lnet/minecraft/world/entity/projectile/Projectile;)V", "newState", "onRemove", "tournament"})
@SourceDebugExtension(value={"SMAP\nBalloonBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonBlock.kt\norg/valkyrienskies/tournament/blocks/BalloonBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n1855#3,2:97\n1855#3,2:99\n*S KotlinDebug\n*F\n+ 1 BalloonBlock.kt\norg/valkyrienskies/tournament/blocks/BalloonBlock\n*L\n85#1:97,2\n72#1:99,2\n*E\n"})
public class BalloonBlock
extends Block {
    public BalloonBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_60918_(SoundType.f_56745_).m_60913_(1.0f, 2.0f));
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos blockPos, @NotNull Entity entity, float f) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.m_142535_(f, 0.2f, new DamageSources(level.m_9598_()).m_268989_());
    }

    @Nullable
    protected final TournamentShips getShipControl(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        TournamentShips tournamentShips;
        ServerShip serverShip;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)((Vec3i)pos));
        ServerShip serverShip2 = serverShip = loadedServerShip != null ? (ServerShip)loadedServerShip : VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)pos);
        if (serverShip != null) {
            ServerShip it = serverShip;
            boolean bl = false;
            tournamentShips = TournamentShips.Companion.getOrCreate(it);
        } else {
            tournamentShips = null;
        }
        return tournamentShips;
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
            if (level.f_46443_) {
                return;
            }
            ServerLevel cfr_ignored_0 = (ServerLevel)level;
            TournamentShips tournamentShips = this.getShipControl((ServerLevel)level, pos);
            if (tournamentShips == null) break block1;
            tournamentShips.addBalloon(pos, TournamentConfig.SERVER.getUnpoweredBalloonMul() * TournamentConfig.SERVER.getBalloonAnalogStrength());
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            super.m_6810_(state, level, pos, newState, isMoving);
            if (level.f_46443_) {
                return;
            }
            ServerLevel cfr_ignored_0 = (ServerLevel)level;
            TournamentShips tournamentShips = this.getShipControl((ServerLevel)level, pos);
            if (tournamentShips == null) break block1;
            tournamentShips.removeBalloon(pos);
        }
    }

    public void m_5581_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        ServerPlayer shooter;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter((Object)projectile, (String)"projectile");
        if ((level instanceof ServerLevel ? (ServerLevel)level : null) == null) {
            return;
        }
        Entity entity = projectile.m_19749_();
        ServerPlayer serverPlayer = shooter = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        if (serverPlayer != null) {
            ServerPlayer player = serverPlayer;
            boolean bl = false;
            TournamentTriggers.INSTANCE.getBALLOON_SHOT_TRIGGER().trigger(player);
        }
        level.m_46961_(hit.m_82425_(), false);
        BlockPos blockPos = hit.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        BalloonBlock.onProjectileHit$shotBalloon(level, shooter, blockPos);
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction it = (Direction)element$iv;
            boolean bl = false;
            BlockPos neighbor = hit.m_82425_().m_121945_(it);
            if (!Intrinsics.areEqual((Object)level.m_8055_(neighbor).m_60734_(), (Object)((Object)this)) || !((double)level.f_46441_.m_188501_() < 0.5)) continue;
            Intrinsics.checkNotNull((Object)neighbor);
            BalloonBlock.onProjectileHit$shotBalloon(level, shooter, neighbor);
            level.m_46961_(neighbor, false);
        }
    }

    private static final void onProjectileHit$shotBalloon(Level $level, ServerPlayer shooter, BlockPos pos) {
        ResourceLocation table = TournamentLootTables.INSTANCE.getBALLOON_POP();
        ServerPlayer serverPlayer = shooter;
        LootParams ctx = new LootParams.Builder((ServerLevel)$level).m_287239_(serverPlayer != null ? serverPlayer.m_36336_() : 0.0f).m_287235_(LootContextParamSets.f_81410_);
        ObjectArrayList loot = ((ServerLevel)$level).m_7654_().m_278653_().m_278676_(table).m_287195_(ctx);
        Intrinsics.checkNotNull((Object)loot);
        Iterable $this$forEach$iv = (Iterable)loot;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemEntity itemEntity;
            ItemStack itemStack = (ItemStack)element$iv;
            boolean bl = false;
            ItemEntity it = itemEntity = new ItemEntity($level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            boolean bl2 = false;
            $level.m_7967_((Entity)it);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

