/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blocks;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;
import org.valkyrienskies.tournament.TournamentConfig;
import org.valkyrienskies.tournament.TournamentTriggers;
import org.valkyrienskies.tournament.util.DirectionalShape;
import org.valkyrienskies.tournament.util.RotShape;
import org.valkyrienskies.tournament.util.RotShapes;
import org.valkyrienskies.tournament.util.ShipAssembler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040\u000fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J?\u0010'\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020#2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b'\u0010(J7\u0010*\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020#2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b*\u0010+J?\u00102\u001a\u0002012\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020#2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020,2\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b2\u00103R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0017\u0010:\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Lorg/valkyrienskies/tournament/blocks/ShipAssemblerBlock;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "<init>", "()V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "asm", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/server/level/ServerPlayer;)Z", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "blockState", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "block", "fromPos", "isMoving", "neighborChanged", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "oldState", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lorg/valkyrienskies/tournament/util/RotShape;", "SHAPE", "Lorg/valkyrienskies/tournament/util/RotShape;", "getSHAPE", "()Lorg/valkyrienskies/tournament/util/RotShape;", "Lorg/valkyrienskies/tournament/util/DirectionalShape;", "Shipifier_SHAPE", "Lorg/valkyrienskies/tournament/util/DirectionalShape;", "getShipifier_SHAPE", "()Lorg/valkyrienskies/tournament/util/DirectionalShape;", "tournament"})
public final class ShipAssemblerBlock
extends DirectionalBlock {
    @NotNull
    private final RotShape SHAPE = RotShapes.INSTANCE.cube();
    @NotNull
    private final DirectionalShape Shipifier_SHAPE = DirectionalShape.Companion.south(this.SHAPE);

    public ShipAssemblerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.0f, 2.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public final RotShape getSHAPE() {
        return this.SHAPE;
    }

    @NotNull
    public final DirectionalShape getShipifier_SHAPE() {
        return this.Shipifier_SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Comparable comparable = state.m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return this.Shipifier_SHAPE.get((Direction)comparable);
    }

    private final boolean asm(BlockState state, ServerLevel level, BlockPos pos, ServerPlayer player) {
        Set<String> blacklist = TournamentConfig.SERVER.getBlockBlacklist();
        if (VSGameUtilsKt.isChunkInShipyard((Level)((Level)level), (int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4))) {
            return false;
        }
        if (!state.m_60795_()) {
            DenseBlockPosSet structure = ShipAssembler.INSTANCE.findStructure(level, pos, blacklist);
            int n = structure.size();
            System.out.println(n);
            ServerShip shipData = ShipAssemblyKt.createNewShipWithBlocks((BlockPos)pos, (DenseBlockPosSet)structure, (ServerLevel)level);
            ServerPlayer serverPlayer = player;
            if (serverPlayer != null) {
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                TournamentTriggers.INSTANCE.getSHIP_ASSEMBLY_TRIGGER().trigger(player, structure.size());
            }
            return true;
        }
        return false;
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.m_6807_(state, level, pos, oldState, isMoving);
        if ((level instanceof ServerLevel ? (ServerLevel)level : null) == null) {
            return;
        }
        int signal = level.m_277086_(pos);
        if (signal > 0) {
            this.asm(state, (ServerLevel)level, pos, null);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if ((level instanceof ServerLevel ? (ServerLevel)level : null) == null) {
            return InteractionResult.PASS;
        }
        if (VSGameUtilsKt.getShipManagingPos((ServerLevel)((ServerLevel)level), (BlockPos)pos) != null) {
            return InteractionResult.PASS;
        }
        if (this.asm(state, (ServerLevel)level, pos, player instanceof ServerPlayer ? (ServerPlayer)player : null)) {
            player.m_213846_((Component)Component.m_237113_((String)"Assembled ship!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"That chunk is already part of a ship!"));
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DirectionalBlock.f_52588_};
        builder.m_61104_(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.f_61426_};
        builder.m_61104_(propertyArray);
        super.m_7926_(builder);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if ((level instanceof ServerLevel ? (ServerLevel)level : null) == null) {
            return;
        }
        int signal = level.m_277086_(pos);
        if (signal > 0) {
            this.asm(state, (ServerLevel)level, pos, null);
        }
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)ctx.m_7820_());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }
}

