/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.blocks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.tournament.TournamentItems;
import org.valkyrienskies.tournament.TournamentProperties;
import org.valkyrienskies.tournament.ship.TournamentShips;
import org.valkyrienskies.tournament.util.DirectionalShape;
import org.valkyrienskies.tournament.util.RotShape;
import org.valkyrienskies.tournament.util.RotShapes;
import org.valkyrienskies.tournament.util.extension.VectorExtensionsKt;
import org.valkyrienskies.tournament.util.helper.Helper3d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0019\u001a\u00020\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b0\u0016H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020 H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b'\u0010(J/\u0010-\u001a\u00020,2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b-\u0010.J!\u00100\u001a\u0004\u0018\u00010/2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b0\u00101J\u0017\u00104\u001a\u00020\u000b2\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b4\u00105J?\u0010:\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u000f2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b:\u0010;J7\u0010=\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\u000b2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b=\u0010>J7\u0010@\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\u000b2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b@\u0010>J?\u0010H\u001a\u00020G2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020A2\u0006\u0010D\u001a\u00020C2\u0006\u0010F\u001a\u00020EH\u0016\u00a2\u0006\u0004\bH\u0010IR\u0014\u0010K\u001a\u00020J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0014\u0010N\u001a\u00020M8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010PR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010PR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010Q\u00a8\u0006R"}, d2={"Lorg/valkyrienskies/tournament/blocks/ThrusterBlock;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "Lkotlin/Function0;", "", "mult", "Lnet/minecraft/core/particles/ParticleOptions;", "particle", "", "maxTier", "<init>", "(Lkotlin/jvm/functions/Function0;Lnet/minecraft/core/particles/ParticleOptions;Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/util/RandomSource;", "randomSource", "", "animateTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/server/level/ServerLevel;", "disableThruster", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", "enableThruster", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/level/storage/loot/LootParams$Builder;", "", "Lnet/minecraft/world/item/ItemStack;", "getDrops", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/storage/loot/LootParams$Builder;)Ljava/util/List;", "blockState", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lorg/valkyrienskies/tournament/ship/TournamentShips;", "getShipControl", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lorg/valkyrienskies/tournament/ship/TournamentShips;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "block", "fromPos", "", "isMoving", "neighborChanged", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "oldState", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "newState", "onRemove", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lorg/valkyrienskies/tournament/util/RotShape;", "SHAPE", "Lorg/valkyrienskies/tournament/util/RotShape;", "Lorg/valkyrienskies/tournament/util/DirectionalShape;", "Thruster_SHAPE", "Lorg/valkyrienskies/tournament/util/DirectionalShape;", "Lkotlin/jvm/functions/Function0;", "Lnet/minecraft/core/particles/ParticleOptions;", "tournament"})
@SourceDebugExtension(value={"SMAP\nThrusterBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrusterBlock.kt\norg/valkyrienskies/tournament/blocks/ThrusterBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
public final class ThrusterBlock
extends DirectionalBlock {
    @NotNull
    private final Function0<Double> mult;
    @NotNull
    private final ParticleOptions particle;
    @NotNull
    private final Function0<Integer> maxTier;
    @NotNull
    private final RotShape SHAPE;
    @NotNull
    private final DirectionalShape Thruster_SHAPE;

    public ThrusterBlock(@NotNull Function0<Double> mult, @NotNull ParticleOptions particle, @NotNull Function0<Integer> maxTier) {
        Intrinsics.checkNotNullParameter(mult, (String)"mult");
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        Intrinsics.checkNotNullParameter(maxTier, (String)"maxTier");
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.0f, 2.0f));
        this.mult = mult;
        this.particle = particle;
        this.maxTier = maxTier;
        this.SHAPE = RotShapes.INSTANCE.box(3.0, 5.0, 4.0, 13.0, 11.0, 16.0);
        this.Thruster_SHAPE = DirectionalShape.Companion.south(this.SHAPE);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(0))).m_61124_((Property)TournamentProperties.INSTANCE.getTIER(), (Comparable)Integer.valueOf(1)));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Comparable comparable = state.m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return this.Thruster_SHAPE.get((Direction)comparable);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        if (Intrinsics.areEqual((Object)player.m_21205_().m_41720_().m_5456_(), (Object)TournamentItems.INSTANCE.getUPGRADE_THRUSTER().get()) && hand == InteractionHand.OFF_HAND) {
            Integer tier = (Integer)state.m_61143_((Property)TournamentProperties.INSTANCE.getTIER());
            Intrinsics.checkNotNull((Object)tier);
            if (tier < ((Number)this.maxTier.invoke()).intValue()) {
                this.disableThruster((ServerLevel)level, pos);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)TournamentProperties.INSTANCE.getTIER(), (Comparable)Integer.valueOf(tier + 1)));
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DirectionalBlock.f_52588_};
        builder.m_61104_(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.f_61426_};
        builder.m_61104_(propertyArray);
        propertyArray = new Property[]{TournamentProperties.INSTANCE.getTIER()};
        builder.m_61104_(propertyArray);
        super.m_7926_(builder);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        int signal = level.m_277086_(pos);
        Integer n = (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_);
        int n2 = signal;
        if (n == null || n != n2) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(signal)));
            return;
        }
        if (signal > 0) {
            this.enableThruster((ServerLevel)level, pos, state);
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!(level instanceof ServerLevel)) {
            return;
        }
        this.disableThruster((ServerLevel)level, pos);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        List drops = super.m_49635_(state, builder);
        Integer tier = (Integer)state.m_61143_((Property)TournamentProperties.INSTANCE.getTIER());
        Intrinsics.checkNotNull((Object)tier);
        if (tier > 1) {
            drops.add(new ItemStack((ItemLike)TournamentItems.INSTANCE.getUPGRADE_THRUSTER().get(), tier - 1));
        }
        Intrinsics.checkNotNull((Object)drops);
        return drops;
    }

    private final TournamentShips getShipControl(Level level, BlockPos pos) {
        TournamentShips tournamentShips;
        ServerShip serverShip;
        LoadedShip loadedShip = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)((Vec3i)pos));
        Ship ship = loadedShip != null ? (Ship)loadedShip : VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
        ServerShip serverShip2 = serverShip = ship instanceof ServerShip ? (ServerShip)ship : null;
        if (serverShip != null) {
            ServerShip it = serverShip;
            boolean bl = false;
            tournamentShips = TournamentShips.Companion.getOrCreate(it);
        } else {
            tournamentShips = null;
        }
        return tournamentShips;
    }

    private final void enableThruster(ServerLevel level, BlockPos pos, BlockState state) {
        block0: {
            TournamentShips tournamentShips = this.getShipControl((Level)level, pos);
            if (tournamentShips == null) break block0;
            TournamentShips it = tournamentShips;
            boolean bl = false;
            it.stopThruster(pos);
            double d = ((Number)((Object)state.m_61143_((Property)TournamentProperties.INSTANCE.getTIER()))).intValue();
            Vec3i vec3i = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)vec3i).mul((double)((Number)((Object)state.m_61143_((Property)BlockStateProperties.f_61426_))).intValue() * ((Number)this.mult.invoke()).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            it.addThruster(pos, d, vector3d);
        }
    }

    private final void disableThruster(ServerLevel level, BlockPos pos) {
        block0: {
            TournamentShips tournamentShips = this.getShipControl((Level)level, pos);
            if (tournamentShips == null) break block0;
            tournamentShips.stopThruster(pos);
        }
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        int signal = level.m_277086_(pos);
        Integer prev = (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_);
        Integer n = prev;
        if (n != null && signal == n) {
            return;
        }
        this.disableThruster((ServerLevel)level, pos);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(signal)));
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Direction dir = ctx.m_7820_();
        if (ctx.m_43723_() != null) {
            Player player = ctx.m_43723_();
            Intrinsics.checkNotNull((Object)player);
            if (player.m_6144_()) {
                dir = dir.m_122424_();
            }
        }
        Object object = this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource randomSource) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)randomSource, (String)"randomSource");
        super.m_214162_(state, level, pos, randomSource);
        Vector3d rp = Helper3d.INSTANCE.getShipRenderPosition(level, VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)));
        if (level.m_46801_(VectorExtensionsKt.toBlock(rp))) {
            return;
        }
        Comparable comparable = state.m_61143_((Property)BlockStateProperties.f_61426_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        if (((Number)((Object)comparable)).intValue() > 0) {
            Direction dir = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            double x = rp.x + 0.5 * (double)(dir.m_122429_() + 1);
            double y = rp.y + 0.5 * (double)(dir.m_122430_() + 1);
            double z = rp.z + 0.5 * (double)(dir.m_122431_() + 1);
            double speedX = (double)dir.m_122429_() * -0.4;
            double speedY = (double)dir.m_122430_() * -0.4;
            double speedZ = (double)dir.m_122431_() * -0.4;
            level.m_7106_(this.particle, x, y, z, speedX, speedY, speedZ);
        }
    }
}

