/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.chunk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.primitives.Rectanglei;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.tournament.TickScheduler;
import org.valkyrienskies.tournament.chunk.ChunkLoader;
import org.valkyrienskies.tournament.chunk.ChunkLoaderManager;
import org.valkyrienskies.tournament.chunk.ChunkLoaderManagerStorage;
import org.valkyrienskies.tournament.chunk.ChunkLoadingTicket;
import org.valkyrienskies.tournament.storage.PersistentLevelStorage;
import org.valkyrienskies.tournament.storage.PersistentLevelStorageKt;
import org.valkyrienskies.tournament.util.extension.IterableExtensionKt;
import org.valkyrienskies.tournament.util.extension.RectangleExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0001)B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u001a\u001a\u00020\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010\u001eR\u0016\u0010(\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010#\u00a8\u0006*"}, d2={"Lorg/valkyrienskies/tournament/chunk/ChunkLoaderManager;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "<init>", "(Lnet/minecraft/server/level/ServerLevel;)V", "Lorg/valkyrienskies/tournament/chunk/ChunkLoader;", "loader", "", "priority", "Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;", "allocate", "(Lorg/valkyrienskies/tournament/chunk/ChunkLoader;I)Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;", "ticket", "", "dispose", "(Lorg/valkyrienskies/tournament/chunk/ChunkLoadingTicket;)V", "Lnet/minecraft/world/level/ChunkPos;", "chunk", "", "shouldCancelUnload", "(Lnet/minecraft/world/level/ChunkPos;)Z", "amountOfTickets", "amountOfChunksPerTicket", "amountOfActualChunksPerTicket", "Ljava/util/function/Consumer;", "tick", "(Ljava/lang/Integer;IILjava/util/function/Consumer;)V", "", "lastTickChunks", "Ljava/util/List;", "Lnet/minecraft/server/level/ServerLevel;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "sorted", "Z", "Lorg/valkyrienskies/tournament/chunk/ChunkLoaderManagerStorage;", "storage", "Lorg/valkyrienskies/tournament/chunk/ChunkLoaderManagerStorage;", "tickets", "unloading", "Companion", "tournament"})
@SourceDebugExtension(value={"SMAP\nChunkLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLoaderManager.kt\norg/valkyrienskies/tournament/chunk/ChunkLoaderManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,160:1\n1002#2,2:161\n1855#2,2:163\n1855#2:165\n1856#2:169\n350#2,7:170\n603#3:166\n1313#3,2:167\n*S KotlinDebug\n*F\n+ 1 ChunkLoaderManager.kt\norg/valkyrienskies/tournament/chunk/ChunkLoaderManager\n*L\n38#1:161,2\n52#1:163,2\n57#1:165\n57#1:169\n85#1:170,7\n68#1:166\n72#1:167,2\n*E\n"})
public final class ChunkLoaderManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final List<ChunkLoadingTicket> tickets;
    private boolean sorted;
    @NotNull
    private final ChunkLoaderManagerStorage storage;
    private boolean unloading;
    @NotNull
    private final List<ChunkPos> lastTickChunks;
    @NotNull
    private static final HashMap<ResourceKey<Level>, ChunkLoaderManager> map = new HashMap();
    private static boolean tickTaskSet;
    @NotNull
    private static final Function1<MinecraftServer, Unit> tickTask;

    private ChunkLoaderManager(ServerLevel level) {
        this.level = level;
        this.tickets = new ArrayList();
        this.sorted = true;
        this.storage = (ChunkLoaderManagerStorage)PersistentLevelStorageKt.readStorage(this.level, (PersistentLevelStorage)new ChunkLoaderManagerStorage());
        this.lastTickChunks = new ArrayList();
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public final void tick(@Nullable Integer amountOfTickets, int amountOfChunksPerTicket, int amountOfActualChunksPerTicket, @NotNull Consumer<ChunkPos> loader) {
        int am;
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        if (!this.sorted) {
            List<ChunkLoadingTicket> $this$sortBy$iv = this.tickets;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ChunkLoadingTicket it = (ChunkLoadingTicket)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPriority());
                        it = (ChunkLoadingTicket)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                    }
                });
            }
            this.sorted = true;
        }
        Integer n = amountOfTickets;
        int n2 = am = n != null ? n.intValue() : this.tickets.size();
        if (this.tickets.size() > am) {
            throw new Exception("[Tournament] Too many chunk-loading tickets in dimension " + this.level.m_46472_() + ": " + this.tickets.size() + " > " + am + "!");
        }
        List<ChunkPos> tl = this.storage.getToLoad();
        tl.clear();
        Iterable $this$forEach$iv = this.tickets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChunkLoadingTicket it = (ChunkLoadingTicket)element$iv;
            boolean bl = false;
            ((Collection)tl).add(it.getLoader().getCurrentChunk());
        }
        this.storage.setToLoad(tl);
        $this$forEach$iv = IterableExtensionKt.itTake((Iterable)this.tickets, am);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            Sequence $this$sortedBy$iv;
            ChunkLoadingTicket ticket = (ChunkLoadingTicket)element$iv;
            boolean bl = false;
            Vector2i mid = VectorConversionsMCKt.toJOML((ChunkPos)ticket.getLoader().getCurrentChunk());
            Vector2i top = VectorConversionsMCKt.toJOML((ChunkPos)ticket.getLoader().getFutureChunk());
            Vector2i bottom = top.sub((Vector2ic)mid, new Vector2i()).negate().add((Vector2ic)mid);
            Rectanglei box = RectangleExtensionsKt.fix(new Rectanglei((Vector2ic)top, (Vector2ic)bottom));
            float t = (float)box.area() / (float)amountOfChunksPerTicket;
            Sequence<Vector2i> sequence = RectangleExtensionsKt.values(RectangleExtensionsKt.scaleFrom(box, t, mid));
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.plus((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(mid){
                final /* synthetic */ Vector2i $mid$inlined;
                {
                    this.$mid$inlined = vector2i;
                }

                public final int compare(T a, T b) {
                    Vector2i it = (Vector2i)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.distanceSquared((Vector2ic)this.$mid$inlined));
                    it = (Vector2i)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.distanceSquared((Vector2ic)this.$mid$inlined)));
                }
            }), (int)amountOfActualChunksPerTicket), (Function1)tick.3.2.INSTANCE), (Iterable)tl);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ChunkPos it = (ChunkPos)element$iv2;
                boolean bl2 = false;
                ((Collection)this.lastTickChunks).add(it);
                loader.accept(it);
            }
        }
    }

    public static /* synthetic */ void tick$default(ChunkLoaderManager chunkLoaderManager, Integer n, int n2, int n3, Consumer consumer, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = null;
        }
        chunkLoaderManager.tick(n, n2, n3, consumer);
    }

    public final boolean shouldCancelUnload(@NotNull ChunkPos chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        return !this.unloading && this.lastTickChunks.contains(chunk);
    }

    @NotNull
    public final ChunkLoadingTicket allocate(@NotNull ChunkLoader loader, int priority) {
        ChunkLoadingTicket chunkLoadingTicket;
        int i;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            List<ChunkLoadingTicket> $this$indexOfFirst$iv = this.tickets;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<ChunkLoadingTicket> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                ChunkLoadingTicket item$iv;
                ChunkLoadingTicket it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getLoader(), (Object)loader)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = i = -1;
        }
        if (i != -1) {
            ChunkLoadingTicket ticket = this.tickets.get(i);
            ticket.setPriority(priority);
            return ticket;
        }
        ChunkLoadingTicket it = chunkLoadingTicket = new ChunkLoadingTicket(this, loader, priority);
        boolean bl = false;
        ((Collection)this.tickets).add(it);
        if (this.tickets.size() > 1) {
            this.sorted = false;
        }
        return chunkLoadingTicket;
    }

    public final void dispose(@NotNull ChunkLoadingTicket ticket) {
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        ((Collection)this.tickets).remove(ticket);
    }

    public /* synthetic */ ChunkLoaderManager(ServerLevel level, DefaultConstructorMarker $constructor_marker) {
        this(level);
    }

    public static final /* synthetic */ void access$setUnloading$p(ChunkLoaderManager $this, boolean bl) {
        $this.unloading = bl;
    }

    public static final /* synthetic */ List access$getLastTickChunks$p(ChunkLoaderManager $this) {
        return $this.lastTickChunks;
    }

    static {
        tickTask = Companion.tickTask.1.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bR<\u0010\u000e\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00060\nj\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u0006`\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/valkyrienskies/tournament/chunk/ChunkLoaderManager$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/tournament/chunk/ChunkLoaderManager;", "getFor", "(Lnet/minecraft/server/level/ServerLevel;)Lorg/valkyrienskies/tournament/chunk/ChunkLoaderManager;", "getForOrNull", "Ljava/util/HashMap;", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "Lkotlin/collections/HashMap;", "map", "Ljava/util/HashMap;", "Lkotlin/Function1;", "Lnet/minecraft/server/MinecraftServer;", "", "tickTask", "Lkotlin/jvm/functions/Function1;", "", "tickTaskSet", "Z", "tournament"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ChunkLoaderManager getForOrNull(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return (ChunkLoaderManager)map.get(level.m_46472_());
        }

        @NotNull
        public final ChunkLoaderManager getFor(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            ResourceKey dim = level.m_46472_();
            if (((Map)map).containsKey(dim)) {
                Object v = map.get(dim);
                Intrinsics.checkNotNull(v);
                return (ChunkLoaderManager)v;
            }
            ChunkLoaderManager lm = new ChunkLoaderManager(level, null);
            Map map = map;
            Intrinsics.checkNotNull((Object)dim);
            map.put(dim, lm);
            if (!tickTaskSet) {
                tickTaskSet = true;
                TickScheduler.INSTANCE.serverTickPerm((Function1<? super MinecraftServer, Unit>)tickTask);
            }
            return lm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

