/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.items;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.tournament.TournamentConfig;
import org.valkyrienskies.tournament.ship.TournamentShips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/tournament/items/PulseGunItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/Rarity;", "getRarity", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/Rarity;", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lorg/joml/Vector3d;", "pulseForce", "Lorg/joml/Vector3d;", "tournament"})
public final class PulseGunItem
extends Item {
    @Nullable
    private Vector3d pulseForce;

    public PulseGunItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Rarity.COMMON;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        double force = TournamentConfig.SERVER.getPulseGunForce();
        Player player = context.m_43723_();
        BlockPos blockPosition = context.m_8083_();
        Vec3 blockLocation = context.m_43720_();
        if (context.m_43725_().f_46443_ || player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Intrinsics.checkNotNull((Object)blockPosition);
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPosition));
        if (loadedServerShip == null) {
            return InteractionResult.PASS;
        }
        LoadedServerShip ship = loadedServerShip;
        Vec3 vec3 = player.m_20154_().m_82541_().m_82490_(force * ship.getInertiaData().getMass());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        this.pulseForce = VectorConversionsMCKt.toJOML((Vec3)vec3);
        TournamentShips tournamentShips = TournamentShips.Companion.getOrCreate((ServerShip)ship);
        Intrinsics.checkNotNull((Object)blockLocation);
        Vector3d vector3d = VectorConversionsMCKt.toJOML((Vec3)blockLocation);
        Vector3d vector3d2 = this.pulseForce;
        Intrinsics.checkNotNull((Object)vector3d2);
        tournamentShips.addPulse(vector3d, vector3d2);
        InteractionResult interactionResult = super.m_6225_(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

