/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.items;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.tournament.util.extension.ShipObjectServerExtensionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/valkyrienskies/tournament/items/ShipDeleteWandItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/Rarity;", "getRarity", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/Rarity;", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "tournament"})
public final class ShipDeleteWandItem
extends Item {
    public ShipDeleteWandItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Rarity.EPIC;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = context.m_8083_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
        if (loadedServerShip == null) {
            return InteractionResult.PASS;
        }
        LoadedServerShip ship = loadedServerShip;
        ShipObjectServerExtensionKt.delete((ServerShip)ship, (ServerLevel)level);
        Player player = context.m_43723_();
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)"chat.vs_tournament.delete_wand.deleted"));
        }
        InteractionResult interactionResult = super.m_6225_(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

