/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.ship;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.tournament.TickScheduler;
import org.valkyrienskies.tournament.TournamentConfig;
import org.valkyrienskies.tournament.blockentity.PropellerBlockEntity;
import org.valkyrienskies.tournament.util.extension.StringExtensionKt;
import org.valkyrienskies.tournament.util.extension.VectorExtensionsKt;
import org.valkyrienskies.tournament.util.helper.Helper3d;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 @2\u00020\u0001:\u0003@ABB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000f\u001a\u00020\b2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\b2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\f0\u000b\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u001d\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0019\u0010\u0014J'\u0010\u001a\u001a\u00020\b2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\f0\u000b\u00a2\u0006\u0004\b\u001a\u0010\u0010J%\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010\u001f\u001a\u00020\b2\u001e\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u001e0\u000b\u00a2\u0006\u0004\b\u001f\u0010\u0010J\u0017\u0010\"\u001a\u00020\b2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\r\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\r\u00a2\u0006\u0004\b(\u0010'J\u0015\u0010)\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b)\u0010%R&\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R&\u0010/\u001a\u00060-j\u0002`.8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00106\u001a\b\u0012\u0004\u0012\u0002050*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u0010,R&\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u0010,R&\u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010,R\u001d\u0010:\u001a\b\u0012\u0004\u0012\u0002090*8\u0006\u00a2\u0006\f\n\u0004\b:\u0010,\u001a\u0004\b;\u0010<R\u0018\u0010>\u001a\u0004\u0018\u00010=8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006C"}, d2={"Lorg/valkyrienskies/tournament/ship/TournamentShips;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "<init>", "()V", "Lnet/minecraft/core/BlockPos;", "pos", "", "pow", "", "addBalloon", "(Lnet/minecraft/core/BlockPos;D)V", "", "Lkotlin/Pair;", "Lorg/joml/Vector3i;", "list", "addBalloons", "(Ljava/lang/Iterable;)V", "Lorg/joml/Vector3d;", "force", "addPropeller", "(Lorg/joml/Vector3i;Lorg/joml/Vector3d;)V", "addPulse", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;)V", "addPulses", "torque", "addSpinner", "addSpinners", "tier", "addThruster", "(Lnet/minecraft/core/BlockPos;DLorg/joml/Vector3d;)V", "Lkotlin/Triple;", "addThrusters", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "applyForces", "(Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "removeBalloon", "(Lnet/minecraft/core/BlockPos;)V", "removePropeller", "(Lorg/joml/Vector3i;)V", "removeSpinner", "stopThruster", "Ljava/util/concurrent/CopyOnWriteArrayList;", "balloons", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "level", "Ljava/lang/String;", "getLevel", "()Ljava/lang/String;", "setLevel", "(Ljava/lang/String;)V", "Lorg/valkyrienskies/tournament/ship/TournamentShips$PropellerData;", "propellers", "pulses", "spinners", "Lorg/valkyrienskies/tournament/ship/TournamentShips$ThrusterData;", "thrusters", "getThrusters", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/valkyrienskies/tournament/TickScheduler$Ticking;", "ticker", "Lorg/valkyrienskies/tournament/TickScheduler$Ticking;", "Companion", "PropellerData", "ThrusterData", "tournament"})
@SourceDebugExtension(value={"SMAP\nTournamentShips.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentShips.kt\norg/valkyrienskies/tournament/ship/TournamentShips\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1855#2,2:254\n1855#2,2:256\n1855#2,2:258\n1855#2,2:260\n1855#2,2:262\n1855#2,2:264\n*S KotlinDebug\n*F\n+ 1 TournamentShips.kt\norg/valkyrienskies/tournament/ship/TournamentShips\n*L\n106#1:254,2\n125#1:256,2\n149#1:258,2\n157#1:260,2\n166#1:262,2\n191#1:264,2\n*E\n"})
public final class TournamentShips
implements ShipForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String level = "minecraft:overworld";
    @NotNull
    private final CopyOnWriteArrayList<ThrusterData> thrusters = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<Pair<Vector3i, Double>> balloons = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<Pair<Vector3i, Vector3d>> spinners = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<Pair<Vector3d, Vector3d>> pulses = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<PropellerData> propellers = new CopyOnWriteArrayList();
    @JsonIgnore
    @Nullable
    private TickScheduler.Ticking ticker;

    @NotNull
    public final String getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.level = string;
    }

    @NotNull
    public final CopyOnWriteArrayList<ThrusterData> getThrusters() {
        return this.thrusters;
    }

    public void applyForces(@NotNull PhysShip physShip) {
        Object it;
        Vector3d tForce;
        Vector3i pos;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        PhysShipImpl cfr_ignored_0 = (PhysShipImpl)physShip;
        if (this.ticker == null) {
            this.ticker = TickScheduler.INSTANCE.serverTickPerm((Function1<? super MinecraftServer, Unit>)((Function1)new Function1<MinecraftServer, Unit>(this){
                final /* synthetic */ TournamentShips this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull MinecraftServer server) {
                    boolean water;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    ServerLevel serverLevel = server.m_129880_(StringExtensionKt.toDimensionKey(this.this$0.getLevel()));
                    if (serverLevel == null) {
                        return;
                    }
                    ServerLevel lvl = serverLevel;
                    Iterable $this$forEach$iv = this.this$0.getThrusters();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ThrusterData t = (ThrusterData)element$iv;
                        boolean bl = false;
                        water = lvl.m_46801_(VectorExtensionsKt.toBlock(Helper3d.INSTANCE.convertShipToWorldSpace((Level)lvl, VectorExtensionsKt.toDouble(t.getPos()))));
                        t.setSubmerged(water);
                    }
                    $this$forEach$iv = TournamentShips.access$getPropellers$p(this.this$0);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PropellerData p = (PropellerData)element$iv;
                        boolean bl = false;
                        water = lvl.m_46801_(VectorExtensionsKt.toBlock(Helper3d.INSTANCE.convertShipToWorldSpace((Level)lvl, VectorExtensionsKt.toDouble(p.getPos()))));
                        p.setTouchingWater(water);
                        PropellerBlockEntity be = (PropellerBlockEntity)lvl.m_7702_(VectorConversionsMCKt.toBlockPos((Vector3ic)((Vector3ic)p.getPos())));
                        if (be == null) continue;
                        p.getSpeed().set(be.getSpeed());
                    }
                }
            }));
        }
        Vector3dc vel = ((PhysShipImpl)physShip).getPoseVel().getVel();
        Iterable $this$forEach$iv = this.thrusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThrusterData data = (ThrusterData)element$iv;
            boolean bl = false;
            pos = data.component1();
            Vector3d force = data.component2();
            double tier = data.component3();
            boolean submerged = data.component4();
            if (submerged) continue;
            tForce = ((PhysShipImpl)physShip).getTransform().getShipToWorld().transformDirection((Vector3dc)force, new Vector3d());
            Vector3d tPos = VectorExtensionsKt.toDouble(pos).add(0.5, 0.5, 0.5).sub(((PhysShipImpl)physShip).getTransform().getPositionInShip());
            if (!force.isFinite() || !(TournamentConfig.SERVER.getThrusterShutoffSpeed() == -1.0) && !(((PhysShipImpl)physShip).getPoseVel().getVel().length() < TournamentConfig.SERVER.getThrusterShutoffSpeed())) continue;
            Vector3d vector3d = tForce.mul(TournamentConfig.SERVER.getThrusterSpeed() * tier);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            Vector3dc vector3dc = (Vector3dc)vector3d;
            Intrinsics.checkNotNull((Object)tPos);
            physShip.applyInvariantForceToPos(vector3dc, (Vector3dc)tPos);
        }
        $this$forEach$iv = this.balloons;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            pos = (Vector3i)it.component1();
            double pow = ((Number)it.component2()).doubleValue();
            Vector3d tPos = new Vector3d((Vector3ic)pos).add(0.5, 0.5, 0.5).sub(((PhysShipImpl)physShip).getTransform().getPositionInShip());
            double tHeight = ((PhysShipImpl)physShip).getTransform().getPositionInWorld().y();
            double tPValue = TournamentConfig.SERVER.getBalloonBaseHeight() - tHeight * tHeight / 1000.0;
            if (vel.y() > 10.0) {
                tPValue = -vel.y() * 0.25;
                tPValue -= vel.y() * 0.25;
            }
            if (tPValue <= 0.0) {
                tPValue = 0.0;
            }
            Vector3dc vector3dc = (Vector3dc)new Vector3d(0.0, (pow + 1.0) * TournamentConfig.SERVER.getBalloonPower() * tPValue, 0.0);
            Intrinsics.checkNotNull((Object)tPos);
            physShip.applyInvariantForceToPos(vector3dc, (Vector3dc)tPos);
        }
        $this$forEach$iv = this.spinners;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            Vector3d torque = (Vector3d)it.component2();
            Vector3d torqueGlobal = ((PhysShipImpl)physShip).getTransform().getShipToWorldRotation().transform((Vector3dc)torque, new Vector3d());
            Vector3d vector3d = torqueGlobal.mul(TournamentConfig.SERVER.getSpinnerSpeed());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            physShip.applyInvariantTorque((Vector3dc)vector3d);
        }
        $this$forEach$iv = this.pulses;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            pos = (Vector3d)it.component1();
            Vector3d force = (Vector3d)it.component2();
            Vector3d tPos = pos.add(0.5, 0.5, 0.5).sub(((PhysShipImpl)physShip).getTransform().getPositionInShip());
            Vector3d tForce2 = ((PhysShipImpl)physShip).getTransform().getWorldToShip().transformDirection(force);
            Intrinsics.checkNotNull((Object)tForce2);
            Vector3dc vector3dc = (Vector3dc)tForce2;
            Intrinsics.checkNotNull((Object)tPos);
            physShip.applyRotDependentForceToPos(vector3dc, (Vector3dc)tPos);
        }
        this.pulses.clear();
        $this$forEach$iv = this.propellers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PropellerData)element$iv;
            boolean bl = false;
            pos = ((PropellerData)it).component1();
            Vector3d force = ((PropellerData)it).component2();
            AtomicDouble speed = ((PropellerData)it).component3();
            boolean touchingWater = ((PropellerData)it).component4();
            if (!touchingWater) continue;
            Vector3d tPos = VectorExtensionsKt.toDouble(pos).add(0.5, 0.5, 0.5).sub(((PhysShipImpl)physShip).getTransform().getPositionInShip());
            tForce = ((PhysShipImpl)physShip).getTransform().getShipToWorld().transformDirection((Vector3dc)force, new Vector3d());
            Vector3d vector3d = tForce.mul(speed.get());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            Vector3dc vector3dc = (Vector3dc)vector3d;
            Intrinsics.checkNotNull((Object)tPos);
            physShip.applyInvariantForceToPos(vector3dc, (Vector3dc)tPos);
        }
    }

    public final void addThruster(@NotNull BlockPos pos, double tier, @NotNull Vector3d force) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        ((Collection)this.thrusters).add(new ThrusterData(VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)pos)), force, tier, false));
    }

    public final void addThrusters(@NotNull Iterable<? extends Triple<? extends Vector3i, ? extends Vector3d, Double>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable<? extends Triple<? extends Vector3i, ? extends Vector3d, Double>> $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator<? extends Triple<? extends Vector3i, ? extends Vector3d, Double>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Triple<? extends Vector3i, ? extends Vector3d, Double> element$iv;
            Triple<? extends Vector3i, ? extends Vector3d, Double> triple = element$iv = iterator2.next();
            boolean bl = false;
            Vector3i pos = (Vector3i)triple.component1();
            Vector3d force = (Vector3d)triple.component2();
            double tier = ((Number)triple.component3()).doubleValue();
            ((Collection)this.thrusters).add(new ThrusterData(pos, force, tier, false));
        }
    }

    public final void stopThruster(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.thrusters.removeIf(arg_0 -> TournamentShips.stopThruster$lambda$6((Function1)new Function1<ThrusterData, Boolean>(pos){
            final /* synthetic */ BlockPos $pos;
            {
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ThrusterData it) {
                return Intrinsics.areEqual((Object)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)this.$pos)), (Object)it.getPos());
            }
        }, arg_0));
    }

    public final void addBalloon(@NotNull BlockPos pos, double pow) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.balloons.add((Pair<Vector3i, Double>)TuplesKt.to((Object)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)pos)), (Object)pow));
    }

    public final void addBalloons(@NotNull Iterable<? extends Pair<? extends Vector3i, Double>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        CollectionsKt.addAll((Collection)this.balloons, list);
    }

    public final void removeBalloon(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CollectionsKt.removeAll((List)this.balloons, (Function1)((Function1)new Function1<Pair<? extends Vector3i, ? extends Double>, Boolean>(pos){
            final /* synthetic */ BlockPos $pos;
            {
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Pair<? extends Vector3i, Double> it) {
                return Intrinsics.areEqual((Object)it.getFirst(), (Object)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)this.$pos)));
            }
        }));
    }

    public final void addSpinner(@NotNull Vector3i pos, @NotNull Vector3d torque) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)torque, (String)"torque");
        this.spinners.add((Pair<Vector3i, Vector3d>)TuplesKt.to((Object)pos, (Object)torque));
    }

    public final void addSpinners(@NotNull Iterable<? extends Pair<? extends Vector3i, ? extends Vector3d>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        CollectionsKt.addAll((Collection)this.spinners, list);
    }

    public final void removeSpinner(@NotNull Vector3i pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CollectionsKt.removeAll((List)this.spinners, (Function1)((Function1)new Function1<Pair<? extends Vector3i, ? extends Vector3d>, Boolean>(pos){
            final /* synthetic */ Vector3i $pos;
            {
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Pair<? extends Vector3i, ? extends Vector3d> it) {
                return Intrinsics.areEqual((Object)it.getFirst(), (Object)this.$pos);
            }
        }));
    }

    public final void addPulse(@NotNull Vector3d pos, @NotNull Vector3d force) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        this.pulses.add((Pair<Vector3d, Vector3d>)TuplesKt.to((Object)pos, (Object)force));
    }

    public final void addPulses(@NotNull Iterable<? extends Pair<? extends Vector3d, ? extends Vector3d>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        CollectionsKt.addAll((Collection)this.pulses, list);
    }

    public final void addPropeller(@NotNull Vector3i pos, @NotNull Vector3d force) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        ((Collection)this.propellers).add(new PropellerData(pos, force, new AtomicDouble(), false));
    }

    public final void removePropeller(@NotNull Vector3i pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.propellers.removeIf(arg_0 -> TournamentShips.removePropeller$lambda$7((Function1)new Function1<PropellerData, Boolean>(pos){
            final /* synthetic */ Vector3i $pos;
            {
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PropellerData it) {
                return Intrinsics.areEqual((Object)it.getPos(), (Object)this.$pos);
            }
        }, arg_0));
    }

    private static final boolean stopThruster$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePropeller$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getPropellers$p(TournamentShips $this) {
        return $this.propellers;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u000b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0004\b\u0007\u0010\f\u00a8\u0006\r"}, d2={"Lorg/valkyrienskies/tournament/ship/TournamentShips$Companion;", "", "<init>", "()V", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/tournament/ship/TournamentShips;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)Lorg/valkyrienskies/tournament/ship/TournamentShips;", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "level", "(Lorg/valkyrienskies/core/api/ships/ServerShip;Ljava/lang/String;)Lorg/valkyrienskies/tournament/ship/TournamentShips;", "tournament"})
    @SourceDebugExtension(value={"SMAP\nTournamentShips.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentShips.kt\norg/valkyrienskies/tournament/ship/TournamentShips$Companion\n+ 2 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n*L\n1#1,253:1\n40#2:254\n37#2:255\n*S KotlinDebug\n*F\n+ 1 TournamentShips.kt\norg/valkyrienskies/tournament/ship/TournamentShips$Companion\n*L\n244#1:254\n247#1:255\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TournamentShips getOrCreate(@NotNull ServerShip ship, @NotNull String level) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            ServerShip $this$getAttachment$iv = ship;
            boolean $i$f$getAttachment = false;
            TournamentShips tournamentShips = (TournamentShips)$this$getAttachment$iv.getAttachment(TournamentShips.class);
            if (tournamentShips == null) {
                TournamentShips tournamentShips2;
                TournamentShips it = tournamentShips2 = new TournamentShips();
                boolean bl = false;
                it.setLevel(level);
                ServerShip $this$saveAttachment$iv = ship;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(TournamentShips.class, (Object)it);
                tournamentShips = tournamentShips2;
            }
            return tournamentShips;
        }

        @NotNull
        public final TournamentShips getOrCreate(@NotNull ServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            return this.getOrCreate(ship, ship.getChunkClaimDimension());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J8\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\rR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010#\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010&R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010'\u001a\u0004\b(\u0010\u0013\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lorg/valkyrienskies/tournament/ship/TournamentShips$PropellerData;", "", "Lorg/joml/Vector3i;", "pos", "Lorg/joml/Vector3d;", "force", "Lcom/google/common/util/concurrent/AtomicDouble;", "speed", "", "touchingWater", "<init>", "(Lorg/joml/Vector3i;Lorg/joml/Vector3d;Lcom/google/common/util/concurrent/AtomicDouble;Z)V", "component1", "()Lorg/joml/Vector3i;", "component2", "()Lorg/joml/Vector3d;", "component3", "()Lcom/google/common/util/concurrent/AtomicDouble;", "component4", "()Z", "copy", "(Lorg/joml/Vector3i;Lorg/joml/Vector3d;Lcom/google/common/util/concurrent/AtomicDouble;Z)Lorg/valkyrienskies/tournament/ship/TournamentShips$PropellerData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3d;", "getForce", "Lorg/joml/Vector3i;", "getPos", "Lcom/google/common/util/concurrent/AtomicDouble;", "getSpeed", "setSpeed", "(Lcom/google/common/util/concurrent/AtomicDouble;)V", "Z", "getTouchingWater", "setTouchingWater", "(Z)V", "tournament"})
    public static final class PropellerData {
        @NotNull
        private final Vector3i pos;
        @NotNull
        private final Vector3d force;
        @NotNull
        private AtomicDouble speed;
        private boolean touchingWater;

        public PropellerData(@NotNull Vector3i pos, @NotNull Vector3d force, @NotNull AtomicDouble speed, boolean touchingWater) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)force, (String)"force");
            Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
            this.pos = pos;
            this.force = force;
            this.speed = speed;
            this.touchingWater = touchingWater;
        }

        @NotNull
        public final Vector3i getPos() {
            return this.pos;
        }

        @NotNull
        public final Vector3d getForce() {
            return this.force;
        }

        @NotNull
        public final AtomicDouble getSpeed() {
            return this.speed;
        }

        public final void setSpeed(@NotNull AtomicDouble atomicDouble) {
            Intrinsics.checkNotNullParameter((Object)atomicDouble, (String)"<set-?>");
            this.speed = atomicDouble;
        }

        public final boolean getTouchingWater() {
            return this.touchingWater;
        }

        public final void setTouchingWater(boolean bl) {
            this.touchingWater = bl;
        }

        @NotNull
        public final Vector3i component1() {
            return this.pos;
        }

        @NotNull
        public final Vector3d component2() {
            return this.force;
        }

        @NotNull
        public final AtomicDouble component3() {
            return this.speed;
        }

        public final boolean component4() {
            return this.touchingWater;
        }

        @NotNull
        public final PropellerData copy(@NotNull Vector3i pos, @NotNull Vector3d force, @NotNull AtomicDouble speed, boolean touchingWater) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)force, (String)"force");
            Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
            return new PropellerData(pos, force, speed, touchingWater);
        }

        public static /* synthetic */ PropellerData copy$default(PropellerData propellerData, Vector3i vector3i, Vector3d vector3d, AtomicDouble atomicDouble, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                vector3i = propellerData.pos;
            }
            if ((n & 2) != 0) {
                vector3d = propellerData.force;
            }
            if ((n & 4) != 0) {
                atomicDouble = propellerData.speed;
            }
            if ((n & 8) != 0) {
                bl = propellerData.touchingWater;
            }
            return propellerData.copy(vector3i, vector3d, atomicDouble, bl);
        }

        @NotNull
        public String toString() {
            return "PropellerData(pos=" + this.pos + ", force=" + this.force + ", speed=" + this.speed + ", touchingWater=" + this.touchingWater + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.force.hashCode();
            result = result * 31 + this.speed.hashCode();
            result = result * 31 + Boolean.hashCode(this.touchingWater);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropellerData)) {
                return false;
            }
            PropellerData propellerData = (PropellerData)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)propellerData.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.force, (Object)propellerData.force)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.speed, (Object)propellerData.speed)) {
                return false;
            }
            return this.touchingWater == propellerData.touchingWater;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J8\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010#\u001a\u0004\b$\u0010\rR\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010%\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lorg/valkyrienskies/tournament/ship/TournamentShips$ThrusterData;", "", "Lorg/joml/Vector3i;", "pos", "Lorg/joml/Vector3d;", "force", "", "mult", "", "submerged", "<init>", "(Lorg/joml/Vector3i;Lorg/joml/Vector3d;DZ)V", "component1", "()Lorg/joml/Vector3i;", "component2", "()Lorg/joml/Vector3d;", "component3", "()D", "component4", "()Z", "copy", "(Lorg/joml/Vector3i;Lorg/joml/Vector3d;DZ)Lorg/valkyrienskies/tournament/ship/TournamentShips$ThrusterData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3d;", "getForce", "D", "getMult", "Lorg/joml/Vector3i;", "getPos", "Z", "getSubmerged", "setSubmerged", "(Z)V", "tournament"})
    public static final class ThrusterData {
        @NotNull
        private final Vector3i pos;
        @NotNull
        private final Vector3d force;
        private final double mult;
        private boolean submerged;

        public ThrusterData(@NotNull Vector3i pos, @NotNull Vector3d force, double mult, boolean submerged) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)force, (String)"force");
            this.pos = pos;
            this.force = force;
            this.mult = mult;
            this.submerged = submerged;
        }

        @NotNull
        public final Vector3i getPos() {
            return this.pos;
        }

        @NotNull
        public final Vector3d getForce() {
            return this.force;
        }

        public final double getMult() {
            return this.mult;
        }

        public final boolean getSubmerged() {
            return this.submerged;
        }

        public final void setSubmerged(boolean bl) {
            this.submerged = bl;
        }

        @NotNull
        public final Vector3i component1() {
            return this.pos;
        }

        @NotNull
        public final Vector3d component2() {
            return this.force;
        }

        public final double component3() {
            return this.mult;
        }

        public final boolean component4() {
            return this.submerged;
        }

        @NotNull
        public final ThrusterData copy(@NotNull Vector3i pos, @NotNull Vector3d force, double mult, boolean submerged) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)force, (String)"force");
            return new ThrusterData(pos, force, mult, submerged);
        }

        public static /* synthetic */ ThrusterData copy$default(ThrusterData thrusterData, Vector3i vector3i, Vector3d vector3d, double d, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                vector3i = thrusterData.pos;
            }
            if ((n & 2) != 0) {
                vector3d = thrusterData.force;
            }
            if ((n & 4) != 0) {
                d = thrusterData.mult;
            }
            if ((n & 8) != 0) {
                bl = thrusterData.submerged;
            }
            return thrusterData.copy(vector3i, vector3d, d, bl);
        }

        @NotNull
        public String toString() {
            return "ThrusterData(pos=" + this.pos + ", force=" + this.force + ", mult=" + this.mult + ", submerged=" + this.submerged + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.force.hashCode();
            result = result * 31 + Double.hashCode(this.mult);
            result = result * 31 + Boolean.hashCode(this.submerged);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrusterData)) {
                return false;
            }
            ThrusterData thrusterData = (ThrusterData)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)thrusterData.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.force, (Object)thrusterData.force)) {
                return false;
            }
            if (Double.compare(this.mult, thrusterData.mult) != 0) {
                return false;
            }
            return this.submerged == thrusterData.submerged;
        }
    }
}

