/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.storage;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.tournament.storage.NBTSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0002\u001d\u001eB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J \u0010\u0014\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/tournament/storage/NBTList;", "T", "Lkotlin/collections/AbstractMutableList;", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "serializer", "<init>", "(Lnet/minecraft/nbt/CompoundTag;Lorg/valkyrienskies/tournament/storage/NBTSerializer;)V", "", "index", "element", "", "add", "(ILjava/lang/Object;)V", "clear", "()V", "get", "(I)Ljava/lang/Object;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "Lnet/minecraft/nbt/CompoundTag;", "getNbt", "()Lnet/minecraft/nbt/CompoundTag;", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "getSize", "()I", "size", "Companion", "Serializer", "tournament"})
public final class NBTList<T>
extends AbstractMutableList<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundTag nbt;
    @NotNull
    private final NBTSerializer<T> serializer;

    public NBTList(@NotNull CompoundTag nbt, @NotNull NBTSerializer<T> serializer) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.nbt = nbt;
        this.serializer = serializer;
    }

    @NotNull
    public final CompoundTag getNbt() {
        return this.nbt;
    }

    public int getSize() {
        return this.nbt.m_128451_("size");
    }

    public T get(int index) {
        CompoundTag compoundTag = this.nbt.m_128469_(String.valueOf(index));
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
        return this.serializer.read(compoundTag);
    }

    public T removeAt(int index) {
        T t = this.get(index);
        int n = this.size() - 1;
        for (int i = index; i < n; ++i) {
            this.nbt.m_128365_(String.valueOf(index), (Tag)this.nbt.m_128469_(String.valueOf(index + 1)));
        }
        this.nbt.m_128473_(String.valueOf(this.size() - 1));
        this.nbt.m_128405_("size", this.size() - 1);
        return t;
    }

    public T set(int index, T element) {
        CompoundTag compoundTag = this.nbt.m_128469_(String.valueOf(index));
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
        this.serializer.write(compoundTag, element);
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return element;
    }

    public void add(int index, T element) {
        CompoundTag compoundTag = this.nbt.m_128469_(String.valueOf(index));
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
        this.serializer.write(compoundTag, element);
        if (index == this.size()) {
            this.nbt.m_128405_("size", this.size() + 1);
        }
    }

    public void clear() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.nbt.m_128473_(String.valueOf(i));
        }
        this.nbt.m_128405_("size", 0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0005\"\u0004\b\u0001\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/tournament/storage/NBTList$Companion;", "", "<init>", "()V", "T", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "elemSerializer", "", "serializer", "(Lorg/valkyrienskies/tournament/storage/NBTSerializer;)Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "tournament"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> NBTSerializer<List<T>> serializer(@NotNull NBTSerializer<T> elemSerializer) {
            Intrinsics.checkNotNullParameter(elemSerializer, (String)"elemSerializer");
            return new Serializer<T>(elemSerializer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00030\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/valkyrienskies/tournament/storage/NBTList$Serializer;", "T", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "", "elemSerializer", "<init>", "(Lorg/valkyrienskies/tournament/storage/NBTSerializer;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "read", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/util/List;", "t", "", "write", "(Lnet/minecraft/nbt/CompoundTag;Ljava/util/List;)V", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "tournament"})
    private static final class Serializer<T>
    implements NBTSerializer<List<T>> {
        @NotNull
        private final NBTSerializer<T> elemSerializer;

        public Serializer(@NotNull NBTSerializer<T> elemSerializer) {
            Intrinsics.checkNotNullParameter(elemSerializer, (String)"elemSerializer");
            this.elemSerializer = elemSerializer;
        }

        @Override
        public void write(@NotNull CompoundTag nbt, @NotNull List<T> t) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter(t, (String)"t");
            nbt.m_128405_("size", t.size());
            int n = t.size();
            for (int i = 0; i < n; ++i) {
                CompoundTag compoundTag = nbt.m_128469_(String.valueOf(i));
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
                this.elemSerializer.write(compoundTag, t.get(i));
            }
        }

        @Override
        @NotNull
        public List<T> read(@NotNull CompoundTag nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            return (List)((Object)new NBTList<T>(nbt, this.elemSerializer));
        }
    }
}

