/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.storage;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.tournament.storage.NBTBasicKt;
import org.valkyrienskies.tournament.storage.NBTChunkPosKt;
import org.valkyrienskies.tournament.storage.NBTList;
import org.valkyrienskies.tournament.storage.NBTSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00002\u00020\u0002:\u0002>?B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006JM\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u000e\"\u0004\b\u0001\u0010\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u000e\"\u0004\b\u0001\u0010\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011\u00a2\u0006\u0004\b\u000f\u0010\u0013J3\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0015\u0012\u0004\u0012\u00028\u00000\u000e\"\u0004\b\u0001\u0010\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0017\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b\u001f\u0010 R#\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R#\u0010'\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b'\u0010#\u001a\u0004\b(\u0010%R$\u0010*\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R#\u0010/\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b/\u0010#\u001a\u0004\b0\u0010%R#\u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b2\u0010#\u001a\u0004\b3\u0010%R#\u00105\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b5\u0010#\u001a\u0004\b6\u0010%R#\u00108\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b8\u0010#\u001a\u0004\b9\u0010%R+\u0010<\u001a\u0016\u0012\f\u0012\n ;*\u0004\u0018\u00010:0:\u0012\u0004\u0012\u00028\u00000\u000e8\u0006\u00a2\u0006\f\n\u0004\b<\u0010#\u001a\u0004\b=\u0010%\u00a8\u0006@"}, d2={"Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage;", "T", "Lnet/minecraft/world/level/saveddata/SavedData;", "Lnet/minecraft/resources/ResourceLocation;", "id", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "E", "Lkotlin/Function1;", "Lnet/minecraft/nbt/CompoundTag;", "get", "Lkotlin/Function2;", "", "set", "Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$SerializingNBTDelegate;", "nbtDelegate", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$SerializingNBTDelegate;", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "serial", "(Lorg/valkyrienskies/tournament/storage/NBTSerializer;)Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$SerializingNBTDelegate;", "elemSerial", "", "nbtList", "nbt", "read$tournament", "(Lnet/minecraft/nbt/CompoundTag;)V", "read", "compoundTag", "save", "(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "", "nbtBool", "Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$SerializingNBTDelegate;", "getNbtBool", "()Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$SerializingNBTDelegate;", "Lnet/minecraft/world/level/ChunkPos;", "nbtChunkPos", "getNbtChunkPos", "<set-?>", "nbtCompound", "Lnet/minecraft/nbt/CompoundTag;", "getNbtCompound", "()Lnet/minecraft/nbt/CompoundTag;", "", "nbtDouble", "getNbtDouble", "", "nbtFloat", "getNbtFloat", "", "nbtInt", "getNbtInt", "", "nbtLong", "getNbtLong", "", "kotlin.jvm.PlatformType", "nbtStr", "getNbtStr", "NBTDelegate", "SerializingNBTDelegate", "tournament"})
@SourceDebugExtension(value={"SMAP\nPersistentLevelStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentLevelStorage.kt\norg/valkyrienskies/tournament/storage/PersistentLevelStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 PersistentLevelStorage.kt\norg/valkyrienskies/tournament/storage/PersistentLevelStorage\n*L\n21#1:114,2\n*E\n"})
public abstract class PersistentLevelStorage<T extends PersistentLevelStorage<T>>
extends SavedData {
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private CompoundTag nbtCompound;
    @NotNull
    private final SerializingNBTDelegate<Integer, T> nbtInt;
    @NotNull
    private final SerializingNBTDelegate<Long, T> nbtLong;
    @NotNull
    private final SerializingNBTDelegate<Float, T> nbtFloat;
    @NotNull
    private final SerializingNBTDelegate<Double, T> nbtDouble;
    @NotNull
    private final SerializingNBTDelegate<Boolean, T> nbtBool;
    @NotNull
    private final SerializingNBTDelegate<String, T> nbtStr;
    @NotNull
    private final SerializingNBTDelegate<ChunkPos, T> nbtChunkPos;

    public PersistentLevelStorage(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.nbtCompound = new CompoundTag();
        this.nbtInt = this.nbtDelegate(NBTBasicKt.getNBTInt());
        this.nbtLong = this.nbtDelegate(NBTBasicKt.getNBTLong());
        this.nbtFloat = this.nbtDelegate(NBTBasicKt.getNBTFloat());
        this.nbtDouble = this.nbtDelegate(NBTBasicKt.getNBTDouble());
        this.nbtBool = this.nbtDelegate(NBTBasicKt.getNBTBool());
        this.nbtStr = this.nbtDelegate(NBTBasicKt.getNBTString());
        this.nbtChunkPos = this.nbtDelegate(NBTChunkPosKt.getNBTChunkPos());
    }

    @NotNull
    public final ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public final CompoundTag getNbtCompound() {
        return this.nbtCompound;
    }

    public final void read$tournament(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        CompoundTag compoundTag = nbt.m_6426_();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"copy(...)");
        this.nbtCompound = compoundTag;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Set set = this.nbtCompound.m_128431_();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Tag tag = this.nbtCompound.m_128423_(key);
            Intrinsics.checkNotNull((Object)tag);
            compoundTag.m_128365_(key, tag);
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return compoundTag;
    }

    @NotNull
    public final <E> SerializingNBTDelegate<E, T> nbtDelegate(@NotNull Function1<? super CompoundTag, ? extends E> get, @NotNull Function2<? super CompoundTag, ? super E, Unit> set) {
        Intrinsics.checkNotNullParameter(get, (String)"get");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        NBTSerializer nBTSerializer = new NBTSerializer<E>(set, get){
            final /* synthetic */ Function2<CompoundTag, E, Unit> $set;
            final /* synthetic */ Function1<CompoundTag, E> $get;
            {
                this.$set = $set;
                this.$get = $get;
            }

            public void write(@NotNull CompoundTag nbt, E t) {
                Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
                this.$set.invoke((Object)nbt, t);
            }

            public E read(@NotNull CompoundTag nbt) {
                Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
                return (E)this.$get.invoke((Object)nbt);
            }
        };
        return new SerializingNBTDelegate<E, T>(nBTSerializer){};
    }

    @NotNull
    public final <E> SerializingNBTDelegate<E, T> nbtDelegate(@NotNull NBTSerializer<E> serial) {
        Intrinsics.checkNotNullParameter(serial, (String)"serial");
        return new SerializingNBTDelegate(serial);
    }

    @NotNull
    public final <E> SerializingNBTDelegate<List<E>, T> nbtList(@NotNull NBTSerializer<E> elemSerial) {
        Intrinsics.checkNotNullParameter(elemSerial, (String)"elemSerial");
        return this.nbtDelegate(NBTList.Companion.serializer(elemSerial));
    }

    @NotNull
    public final SerializingNBTDelegate<Integer, T> getNbtInt() {
        return this.nbtInt;
    }

    @NotNull
    public final SerializingNBTDelegate<Long, T> getNbtLong() {
        return this.nbtLong;
    }

    @NotNull
    public final SerializingNBTDelegate<Float, T> getNbtFloat() {
        return this.nbtFloat;
    }

    @NotNull
    public final SerializingNBTDelegate<Double, T> getNbtDouble() {
        return this.nbtDouble;
    }

    @NotNull
    public final SerializingNBTDelegate<Boolean, T> getNbtBool() {
        return this.nbtBool;
    }

    @NotNull
    public final SerializingNBTDelegate<String, T> getNbtStr() {
        return this.nbtStr;
    }

    @NotNull
    public final SerializingNBTDelegate<ChunkPos, T> getNbtChunkPos() {
        return this.nbtChunkPos;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u000e\b\u0002\u0010\u0003*\b\u0012\u0004\u0012\u00028\u00020\u00022\u00020\u0004BC\b\u0000\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ*\u0010\u0011\u001a\u00028\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J2\u0010\u0014\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0013\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R)\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R/\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$NBTDelegate;", "T", "Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage;", "X", "", "Lkotlin/Function2;", "Lnet/minecraft/nbt/CompoundTag;", "", "get", "Lkotlin/Function3;", "", "set", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;)V", "thisRef", "Lkotlin/reflect/KProperty;", "property", "getValue", "(Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "value", "setValue", "(Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "Lkotlin/jvm/functions/Function2;", "getGet", "()Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function3;", "getSet", "()Lkotlin/jvm/functions/Function3;", "tournament"})
    public static class NBTDelegate<T, X extends PersistentLevelStorage<X>> {
        @NotNull
        private final Function2<CompoundTag, String, T> get;
        @NotNull
        private final Function3<CompoundTag, String, T, Unit> set;

        public NBTDelegate(@NotNull Function2<? super CompoundTag, ? super String, ? extends T> get, @NotNull Function3<? super CompoundTag, ? super String, ? super T, Unit> set) {
            Intrinsics.checkNotNullParameter(get, (String)"get");
            Intrinsics.checkNotNullParameter(set, (String)"set");
            this.get = get;
            this.set = set;
        }

        @NotNull
        public final Function2<CompoundTag, String, T> getGet() {
            return this.get;
        }

        @NotNull
        public final Function3<CompoundTag, String, T, Unit> getSet() {
            return this.set;
        }

        public final T getValue(@NotNull PersistentLevelStorage<X> thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(thisRef, (String)"thisRef");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return (T)this.get.invoke((Object)thisRef.getNbtCompound(), (Object)property.getName());
        }

        public final void setValue(@NotNull PersistentLevelStorage<X> thisRef, @NotNull KProperty<?> property, T value) {
            Unit unit;
            Intrinsics.checkNotNullParameter(thisRef, (String)"thisRef");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            this.set.invoke((Object)thisRef.getNbtCompound(), (Object)property.getName(), value);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            thisRef.m_77762_();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u000e\b\u0002\u0010\u0003*\b\u0012\u0004\u0012\u00028\u00020\u00022\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\b\u0012\u0004\u0012\u00028\u00010\u0005B\u0017\b\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00028\u00012\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$SerializingNBTDelegate;", "T", "Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage;", "X", "Lorg/valkyrienskies/tournament/storage/PersistentLevelStorage$NBTDelegate;", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "serial", "<init>", "(Lorg/valkyrienskies/tournament/storage/NBTSerializer;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "read", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Object;", "t", "", "write", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/Object;)V", "Lorg/valkyrienskies/tournament/storage/NBTSerializer;", "tournament"})
    public static class SerializingNBTDelegate<T, X extends PersistentLevelStorage<X>>
    extends NBTDelegate<T, X>
    implements NBTSerializer<T> {
        @NotNull
        private final NBTSerializer<T> serial;

        public SerializingNBTDelegate(final @NotNull NBTSerializer<T> serial) {
            Intrinsics.checkNotNullParameter(serial, (String)"serial");
            super((Function2)new Function2<CompoundTag, String, T>(){

                public final T invoke(@NotNull CompoundTag nbt, @NotNull String key) {
                    Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    if (!nbt.m_128441_(key)) {
                        nbt.m_128365_(key, (Tag)new CompoundTag());
                    }
                    CompoundTag compoundTag = nbt.m_128469_(key);
                    Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
                    return serial.read(compoundTag);
                }
            }, (Function3)new Function3<CompoundTag, String, T, Unit>(){

                public final void invoke(@NotNull CompoundTag nbt, @NotNull String key, T value) {
                    Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    CompoundTag compoundTag = nbt.m_128469_(key);
                    Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
                    serial.write(compoundTag, value);
                }
            });
            this.serial = serial;
        }

        @Override
        public void write(@NotNull CompoundTag nbt, T t) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            this.serial.write(nbt, t);
        }

        @Override
        public T read(@NotNull CompoundTag nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            return this.serial.read(nbt);
        }
    }
}

