/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.util.algo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJG\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\nJ%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/valkyrienskies/tournament/util/algo/Algo2d;", "", "<init>", "()V", "Lorg/joml/Vector2d;", "vec", "", "r", "", "circle", "(Lorg/joml/Vector2d;D)Ljava/util/List;", "pos", "targetVectors", "filledVectors", "max", "min", "fill", "(Lorg/joml/Vector2d;Ljava/util/List;Ljava/util/List;Lorg/joml/Vector2d;Lorg/joml/Vector2d;)Ljava/util/List;", "fillVectors", "(Lorg/joml/Vector2d;Ljava/util/List;)Ljava/util/List;", "filledCircle", "filledCircleDirty", "tournament"})
@SourceDebugExtension(value={"SMAP\nAlgo2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Algo2d.kt\norg/valkyrienskies/tournament/util/algo/Algo2d\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,3:102\n1549#2:105\n1620#2,3:106\n1549#2:109\n1620#2,3:110\n1549#2:113\n1620#2,3:114\n*S KotlinDebug\n*F\n+ 1 Algo2d.kt\norg/valkyrienskies/tournament/util/algo/Algo2d\n*L\n56#1:101\n56#1:102,3\n57#1:105\n57#1:106,3\n59#1:109\n59#1:110,3\n60#1:113\n60#1:114,3\n*E\n"})
public final class Algo2d {
    @NotNull
    public static final Algo2d INSTANCE = new Algo2d();

    private Algo2d() {
    }

    @NotNull
    public final List<Vector2d> filledCircle(@Nullable Vector2d vec, double r) {
        Vector2d vector2d = vec;
        Intrinsics.checkNotNull((Object)vector2d);
        Vector2d pos = vector2d;
        return this.fillVectors(pos, this.circle(pos, r));
    }

    @NotNull
    public final List<Vector2d> filledCircleDirty(@Nullable Vector2d vec, double r) {
        Vector2d vector2d = vec;
        Intrinsics.checkNotNull((Object)vector2d);
        Vector2d pos = vector2d;
        ArrayList res = new ArrayList();
        int j = 1;
        int n = (int)r * 2;
        if (j <= n) {
            while (true) {
                double i = (double)j / (double)2;
                res.addAll(this.circle(pos, i));
                Vector2d vector2d2 = pos.add(1.0, 1.0);
                Intrinsics.checkNotNullExpressionValue((Object)vector2d2, (String)"add(...)");
                res.addAll(this.circle(vector2d2, i));
                Vector2d vector2d3 = pos.add(1.0, 0.0);
                Intrinsics.checkNotNullExpressionValue((Object)vector2d3, (String)"add(...)");
                res.addAll(this.circle(vector2d3, i));
                Vector2d vector2d4 = pos.add(0.0, 1.0);
                Intrinsics.checkNotNullExpressionValue((Object)vector2d4, (String)"add(...)");
                res.addAll(this.circle(vector2d4, i));
                Vector2d vector2d5 = pos.sub(1.0, 1.0);
                Intrinsics.checkNotNullExpressionValue((Object)vector2d5, (String)"sub(...)");
                res.addAll(this.circle(vector2d5, i));
                Vector2d vector2d6 = pos.sub(1.0, 0.0);
                Intrinsics.checkNotNullExpressionValue((Object)vector2d6, (String)"sub(...)");
                res.addAll(this.circle(vector2d6, i));
                Vector2d vector2d7 = pos.sub(0.0, 1.0);
                Intrinsics.checkNotNullExpressionValue((Object)vector2d7, (String)"sub(...)");
                res.addAll(this.circle(vector2d7, i));
                if (j == n) break;
                ++j;
            }
        }
        return res;
    }

    @NotNull
    public final List<Vector2d> fill(@NotNull Vector2d pos, @NotNull List<? extends Vector2d> targetVectors, @NotNull List<? extends Vector2d> filledVectors, @NotNull Vector2d max, @NotNull Vector2d min) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(targetVectors, (String)"targetVectors");
        Intrinsics.checkNotNullParameter(filledVectors, (String)"filledVectors");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        ArrayList<Vector2d> vecs = new ArrayList<Vector2d>();
        vecs.addAll((Collection)filledVectors);
        if (pos.x < min.x || pos.x > max.x || pos.y < min.y || pos.y > max.y) {
            return vecs;
        }
        if (targetVectors.contains(pos) || vecs.contains(pos)) {
            return vecs;
        }
        System.out.println((Object)("it pos: " + pos + "    max: " + max + "    min: " + min));
        vecs.add(pos);
        vecs.add(pos.add(1.0, 0.0));
        Vector2d vector2d = pos.add(1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vector2d, (String)"add(...)");
        vecs.addAll((Collection)this.fill(vector2d, targetVectors, (List<? extends Vector2d>)vecs, max, min));
        Vector2d vector2d2 = pos.sub(1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vector2d2, (String)"sub(...)");
        vecs.addAll((Collection)this.fill(vector2d2, targetVectors, (List<? extends Vector2d>)vecs, max, min));
        Vector2d vector2d3 = pos.add(0.0, 1.0);
        Intrinsics.checkNotNullExpressionValue((Object)vector2d3, (String)"add(...)");
        vecs.addAll((Collection)this.fill(vector2d3, targetVectors, (List<? extends Vector2d>)vecs, max, min));
        Vector2d vector2d4 = pos.sub(0.0, 1.0);
        Intrinsics.checkNotNullExpressionValue((Object)vector2d4, (String)"sub(...)");
        vecs.addAll((Collection)this.fill(vector2d4, targetVectors, (List<? extends Vector2d>)vecs, max, min));
        return vecs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2d> fillVectors(@NotNull Vector2d pos, @NotNull List<? extends Vector2d> targetVectors) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(targetVectors, (String)"targetVectors");
        Iterable $this$map$iv = targetVectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Iterator<T> it;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Vector2d)it).x);
        }
        double maxX = CollectionsKt.maxOrThrow((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = targetVectors;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator<T> it;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Vector2d)it).y);
        }
        double maxY = CollectionsKt.maxOrThrow((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = targetVectors;
        boolean $i$f$map3 = false;
        Iterable $i$f$mapTo32 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo42 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.x);
        }
        double minX = CollectionsKt.minOrThrow((Iterable)((List)destination$iv$iv3));
        Iterable $this$map$iv4 = targetVectors;
        boolean $i$f$map4 = false;
        Iterable $i$f$mapTo42 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.y);
        }
        double minY = CollectionsKt.minOrThrow((Iterable)((List)destination$iv$iv4));
        List<Vector2d> res = this.fill(pos, targetVectors, new ArrayList(), new Vector2d(maxX, maxY), new Vector2d(minX, minY));
        System.out.println((Object)("Fill Vectors result: " + res.size()));
        return res;
    }

    @NotNull
    public final List<Vector2d> circle(@NotNull Vector2d vec, double r) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        double x0 = vec.x;
        double y0 = vec.y;
        List result = new ArrayList();
        double x = r;
        int y = 0;
        double decisionOver2 = 1.0 - x;
        while ((double)y <= x) {
            result.add(new Vector2d(x + x0, (double)y + y0));
            result.add(new Vector2d((double)y + x0, x + y0));
            result.add(new Vector2d(-x + x0, (double)y + y0));
            result.add(new Vector2d((double)(-y) + x0, x + y0));
            result.add(new Vector2d(-x + x0, (double)(-y) + y0));
            result.add(new Vector2d((double)(-y) + x0, -x + y0));
            result.add(new Vector2d(x + x0, (double)(-y) + y0));
            result.add(new Vector2d((double)y + x0, -x + y0));
            ++y;
            if (decisionOver2 <= 0.0) {
                decisionOver2 += (double)(2 * y + 1);
                continue;
            }
            double d = x;
            x = d + -1.0;
            decisionOver2 += (double)2 * ((double)y - x) + 1.0;
        }
        return result;
    }
}

