/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.util.algo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.valkyrienskies.tournament.util.algo.Algo2d;
import org.valkyrienskies.tournament.util.extension.IntExtensionKt;
import org.valkyrienskies.tournament.util.extension.VectorExtensionsKt;
import org.valkyrienskies.tournament.util.helper.Helper2d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/tournament/util/algo/Algo3d;", "", "<init>", "()V", "Lorg/joml/Vector3d;", "pos", "", "radius", "height", "", "cone", "(Lorg/joml/Vector3d;DD)Ljava/util/List;", "sphere", "(Lorg/joml/Vector3d;D)Ljava/util/List;", "sphereLikeShape", "tournament"})
@SourceDebugExtension(value={"SMAP\nAlgo3d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Algo3d.kt\norg/valkyrienskies/tournament/util/algo/Algo3d\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1549#2:67\n1620#2,3:68\n2661#2,7:71\n*S KotlinDebug\n*F\n+ 1 Algo3d.kt\norg/valkyrienskies/tournament/util/algo/Algo3d\n*L\n14#1:67\n14#1:68,3\n19#1:71,7\n*E\n"})
public final class Algo3d {
    @NotNull
    public static final Algo3d INSTANCE = new Algo3d();

    private Algo3d() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector3d> cone(@NotNull Vector3d pos, double radius, double height) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Iterable $this$map$iv = (Iterable)IntExtensionKt.getRange(0, (int)height);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void y;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Helper2d.INSTANCE.vec2listTo3(Algo2d.INSTANCE.filledCircleDirty(VectorExtensionsKt.to2d(pos), radius * -Math.signum(height) - radius * ((double)y / height)), pos.y + (double)y));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            List $i$f$mapTo2 = (List)iterator$iv.next();
            List a = (List)accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)a, (Iterable)((Iterable)b));
        }
        return (List)accumulator$iv;
    }

    @NotNull
    public final List<Vector3d> sphere(@NotNull Vector3d pos, double radius) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ArrayList result = new ArrayList();
        Vector3d x = pos.add(radius, 0.0, 0.0);
        for (int i = 0; i < 180; ++i) {
            Vector3d y = x.rotateAxis((double)i, 1.0, 0.0, 0.0);
            double r = y.x();
            double h = y.y();
            result.addAll(Helper2d.INSTANCE.vec2listTo3(Algo2d.INSTANCE.filledCircleDirty(new Vector2d(pos.x, pos.y), r), h));
        }
        return result;
    }

    @NotNull
    public final List<Vector3d> sphereLikeShape(@NotNull Vector3d pos, double radius, double height) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ArrayList result = new ArrayList();
        double y = pos.y;
        int i = 0;
        int n = (int)Math.abs(height);
        if (i <= n) {
            while (true) {
                result.addAll(Helper2d.INSTANCE.vec2listTo3(Algo2d.INSTANCE.filledCircleDirty(VectorExtensionsKt.to2d(pos), (double)i / y + pos.y / (double)2), y));
                y = height < 0.0 ? (y -= 1.0) : (y += 1.0);
                if (i == n) break;
                ++i;
            }
        }
        return result;
    }
}

