/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.tournament.util.helper;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\fJ\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rJ-\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J=\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/valkyrienskies/tournament/util/helper/Helper3d;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lorg/joml/Vector3d;", "convertShipToWorldSpace", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lorg/joml/Vector3d;", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)Lorg/joml/Vector3d;", "(Lnet/minecraft/world/level/Level;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "a", "b", "Lnet/minecraft/core/particles/ParticleOptions;", "particle", "", "drawParticleLine", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/particles/ParticleOptions;)V", "c", "", "length", "segments", "drawQuadraticParticleCurve", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;DDLnet/minecraft/world/level/Level;Lnet/minecraft/core/particles/ParticleOptions;)V", "Lnet/minecraft/client/multiplayer/ClientLevel;", "getShipRenderPosition", "(Lnet/minecraft/client/multiplayer/ClientLevel;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "tournament"})
public final class Helper3d {
    @NotNull
    public static final Helper3d INSTANCE = new Helper3d();

    private Helper3d() {
    }

    @NotNull
    public final Vector3d getShipRenderPosition(@NotNull ClientLevel level, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ClientShip clientShip = VSGameUtilsKt.getShipObjectManagingPos((ClientLevel)level, (Vector3dc)((Vector3dc)pos));
        Vector3d vector3d = clientShip != null && (clientShip = clientShip.getRenderTransform()) != null && (clientShip = clientShip.getShipToWorld()) != null ? clientShip.transformPosition(pos) : null;
        return vector3d == null ? pos : vector3d;
    }

    @NotNull
    public final Vector3d getShipRenderPosition(@NotNull Level level, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level level2 = level;
        return level2 instanceof ServerLevel ? this.convertShipToWorldSpace(level, pos) : (level2 instanceof ClientLevel ? this.getShipRenderPosition((ClientLevel)level, pos) : pos);
    }

    @NotNull
    public final Vector3d convertShipToWorldSpace(@NotNull Level level, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LoadedShip loadedShip = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vector3dc)((Vector3dc)pos));
        Vector3d vector3d = loadedShip != null && (loadedShip = loadedShip.getShipToWorld()) != null ? loadedShip.transformPosition(pos) : null;
        return vector3d == null ? pos : vector3d;
    }

    @NotNull
    public final Vector3d convertShipToWorldSpace(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.convertShipToWorldSpace(level, VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)));
    }

    @NotNull
    public final Vector3d convertShipToWorldSpace(@NotNull Level level, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.convertShipToWorldSpace(level, VectorConversionsMCKt.toJOML((Vec3)pos));
    }

    public final void drawParticleLine(@NotNull Vector3d a, @NotNull Vector3d b, @NotNull Level level, @NotNull ParticleOptions particle) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        double le = a.distance((Vector3dc)b) * (double)3;
        int i = 1;
        int n = (int)le;
        if (i <= n) {
            while (true) {
                Vector3d pos = a.lerp((Vector3dc)b, (double)i / le);
                level.m_7106_(particle, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void drawQuadraticParticleCurve(@NotNull Vector3d a, @NotNull Vector3d c, double length, double segments, @NotNull Level level, @NotNull ParticleOptions particle) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        double lengthAC = Math.abs(a.sub((Vector3dc)c).length() * segments);
        double lengthTOT = length * segments;
        Vector3d b = c.sub((Vector3dc)c.sub((Vector3dc)a).div(2.0));
        if (lengthAC < lengthTOT) {
            b.y -= lengthTOT - lengthAC;
        }
        if ((i = 1) <= (n = (int)lengthAC)) {
            while (true) {
                Vector3d x;
                Vector3d e;
                Vector3d d;
                double t = (double)i / lengthAC;
                Intrinsics.checkNotNullExpressionValue((Object)a.lerp((Vector3dc)b, t), (String)"lerp(...)");
                Intrinsics.checkNotNullExpressionValue((Object)b.lerp((Vector3dc)c, t), (String)"lerp(...)");
                Intrinsics.checkNotNullExpressionValue((Object)d.lerp((Vector3dc)e, t), (String)"lerp(...)");
                level.m_7106_(particle, x.x, x.y, x.z, 0.0, 0.0, 0.0);
                if (i == n) break;
                ++i;
            }
        }
    }
}

