/*
 * Decompiled with CFR 0.152.
 */
package spiderman.adaptive_difficulty;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import spiderman.adaptive_difficulty.network.AdaptiveDifficultyModVariables;

public class Adaptive {
    public static final ArrayList<EntityType> canAttack = new ArrayList<EntityType>(List.of(EntityType.f_20521_, EntityType.f_20522_, EntityType.f_20456_, EntityType.f_20500_, EntityType.f_20512_, EntityType.f_20565_, EntityType.f_20466_));
    public static final ArrayList<String> vaildDifficulty = new ArrayList<String>(List.of("peaceful", "easy", "normal", "hard", "hardcore"));

    public static void load(Player player) {
        if (!vaildDifficulty.contains(Adaptive.getDifficultyName(player))) {
            Difficulty difficulty = player.m_9236_().m_46791_();
            if (player.m_9236_().m_7654_().m_7035_()) {
                Adaptive.setDifficulty(player, "hardcore");
            } else {
                Adaptive.setDifficulty(player, difficulty.m_19036_());
            }
        }
    }

    public static void setDifficulty(Player player, String mode) {
        player.getCapability(AdaptiveDifficultyModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.Difficulty = mode;
            capability.syncPlayerVariables((Entity)player);
        });
    }

    public static String getDifficultyName(Player player) {
        return ((AdaptiveDifficultyModVariables.PlayerVariables)player.getCapability(AdaptiveDifficultyModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new AdaptiveDifficultyModVariables.PlayerVariables())).Difficulty;
    }

    public static int getDifficultyId(Player player) {
        String difficulty;
        return switch (difficulty = Adaptive.getDifficultyName(player)) {
            default -> 2;
            case "peaceful" -> 0;
            case "easy" -> 1;
            case "hard" -> 3;
            case "hardcore" -> 4;
        };
    }

    public static Difficulty getDifficulty(Player player) {
        String difficulty;
        return switch (difficulty = Adaptive.getDifficultyName(player)) {
            default -> Difficulty.NORMAL;
            case "peaceful" -> Difficulty.PEACEFUL;
            case "easy" -> Difficulty.EASY;
            case "hard" -> Difficulty.HARD;
            case "hardcore" -> Difficulty.HARD;
        };
    }

    public static int getFoodTick(FoodData data) {
        CompoundTag compound = new CompoundTag();
        data.m_38719_(compound);
        if (compound.m_128441_("foodTickTimer")) {
            return compound.m_128451_("foodTickTimer");
        }
        return 0;
    }

    public static boolean isSameDifficulty(int adaptive, Level world) {
        boolean isHarcore;
        Difficulty difficulty = world.m_46791_();
        MinecraftServer server = world.m_7654_();
        boolean bl = isHarcore = server == null ? false : server.m_7035_();
        if (isHarcore && adaptive != 4) {
            return false;
        }
        if (!isHarcore && adaptive == 4) {
            return false;
        }
        return difficulty.m_19028_() == adaptive;
    }
}

