/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RoarParticle
extends TextureSheetParticle {
    public int r;
    public int g;
    public int b;
    public float endsize;
    public float startsize;
    public float increase;
    private final SpriteSet sprites;

    public RoarParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, int duration, int r, int g, int b, float opacity, float startsize, float increase, float endsize, SpriteSet sprites) {
        super(world, x, y, z);
        this.sprites = sprites;
        this.m_107250_(1.0f, 1.0f);
        this.m_108339_(this.sprites);
        this.f_107663_ = startsize;
        this.startsize = startsize;
        this.increase = increase;
        this.endsize = endsize;
        this.f_107225_ = duration;
        this.f_107227_ = (float)r / 255.0f;
        this.f_107228_ = (float)g / 255.0f;
        this.f_107229_ = (float)b / 255.0f;
        this.f_107230_ = opacity;
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
    }

    public int m_6355_(float delta) {
        return 0xF0 | super.m_6355_(delta) & 0xFF0000;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
            this.f_107663_ += this.increase;
            if (this.increase > 0.0f) {
                this.f_107663_ = Math.min(this.f_107663_, this.endsize);
            } else if (this.increase < 0.0f) {
                this.f_107663_ = Math.max(this.f_107663_, this.endsize);
            }
            this.f_107230_ = Math.max(0.0f, 1.0f - (float)this.f_107224_ / (float)this.f_107225_);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class RoarData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<RoarData> DESERIALIZER = new ParticleOptions.Deserializer<RoarData>(){

            public RoarData fromCommand(ParticleType<RoarData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                float a = reader.readFloat();
                reader.expect(' ');
                float start = reader.readFloat();
                reader.expect(' ');
                float increase = reader.readFloat();
                reader.expect(' ');
                float end = reader.readFloat();
                return new RoarData(duration, r, g, b, a, start, increase, end);
            }

            public RoarData fromNetwork(ParticleType<RoarData> particleTypeIn, FriendlyByteBuf buf) {
                return new RoarData(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
            }
        };
        private final int duration;
        private final int r;
        private final int g;
        private final int b;
        private final float a;
        private final float startsize;
        private final float increase;
        private final float endsize;

        public RoarData(int duration, int r, int g, int b, float a, float startsize, float increase, float endsize) {
            this.duration = duration;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.startsize = startsize;
            this.increase = increase;
            this.endsize = endsize;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.duration);
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeFloat(this.a);
            buffer.writeFloat(this.startsize);
            buffer.writeFloat(this.increase);
            buffer.writeFloat(this.endsize);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %d %.2f %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.duration, this.r, this.g, this.b, Float.valueOf(this.a), Float.valueOf(this.startsize), Float.valueOf(this.increase), Float.valueOf(this.endsize));
        }

        public ParticleType<RoarData> m_6012_() {
            return (ParticleType)ModParticle.ROAR.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getA() {
            return this.a;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getStart() {
            return this.startsize;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getIncrease() {
            return this.increase;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getEnd() {
            return this.endsize;
        }

        public static Codec<RoarData> CODEC(ParticleType<RoarData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("duration").forGetter(RoarData::getDuration), (App)Codec.INT.fieldOf("r").forGetter(RoarData::getR), (App)Codec.INT.fieldOf("g").forGetter(RoarData::getG), (App)Codec.INT.fieldOf("b").forGetter(RoarData::getB), (App)Codec.FLOAT.fieldOf("a").forGetter(RoarData::getA), (App)Codec.FLOAT.fieldOf("start").forGetter(RoarData::getStart), (App)Codec.FLOAT.fieldOf("increase").forGetter(RoarData::getIncrease), (App)Codec.FLOAT.fieldOf("end").forGetter(RoarData::getEnd)).apply((Applicative)codecBuilder, RoarData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class RoarFactory
    implements ParticleProvider<RoarData> {
        private final SpriteSet spriteSet;

        public RoarFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(RoarData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RoarParticle particle = new RoarParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getDuration(), typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getA(), typeIn.getStart(), typeIn.getIncrease(), typeIn.getEnd(), this.spriteSet);
            return particle;
        }
    }
}

