/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.ItemInlineData;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class InlineItemRenderer
implements InlineRenderer<ItemInlineData> {
    public static final InlineItemRenderer INSTANCE = new InlineItemRenderer();
    public static boolean debugEarlyReturn = true;

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("inline", "item");
    }

    @Override
    public int render(ItemInlineData data, GuiGraphics context, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        boolean flat;
        if (trContext.shadow()) {
            return 8;
        }
        PoseStack matrices = context.m_280168_();
        ItemStack stack = data.getStack();
        Minecraft client = Minecraft.m_91087_();
        ClientLevel world = client.f_91073_;
        if (stack.m_41619_()) {
            return 8;
        }
        BakedModel bakedModel = client.m_91291_().m_174264_(stack, (Level)world, null, 0);
        boolean bl = flat = !bakedModel.m_7547_();
        if (flat && InlineRenderer.isFlat(matrices, trContext.layerType())) {
            Lighting.m_84930_();
        }
        matrices.m_85836_();
        matrices.m_252880_(4.0f, 4.0f, 0.0f);
        try {
            matrices.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            matrices.m_85841_(8.0f, 8.0f, 8.0f);
            client.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrices, (MultiBufferSource)context.m_280091_(), trContext.light(), OverlayTexture.f_118083_, bakedModel);
            context.m_280091_().m_109911_();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashReportSection = crashReport.m_127514_("Item being rendered");
            crashReportSection.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashReportSection.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
            crashReportSection.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
            crashReportSection.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
            throw new ReportedException(crashReport);
        }
        matrices.m_85849_();
        return 8;
    }

    @Override
    public int charWidth(ItemInlineData data, Style style, int codepoint) {
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(ItemInlineData forData) {
        BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(forData.getStack(), (Level)Minecraft.m_91087_().f_91073_, null, 0);
        return new GlowHandling.Full(forData.getStack().m_41778_() + Integer.toHexString(bakedModel.hashCode()));
    }
}

