/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.config;

import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.config.InlineClientConfigImpl;
import com.samsthenerd.inline.xplat.IModMeta;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class InlineConfigHandler {
    public static Screen getConfigScreen(Screen parent) {
        InlineClientConfigImpl.getInstance().reloadFromFile();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237115_((String)"config.inline.title"));
        ConfigCategory matcherConfig = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.inline.category.matchers"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (InlineMatcher matcher : InlineClientAPI.INSTANCE.getAllMatchers()) {
            matcherConfig.addEntry(InlineConfigHandler.makeMatcherConfig(entryBuilder, matcher));
        }
        ConfigCategory extraFeatures = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.inline.category.extras"));
        BooleanListEntry modIconEntry = entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.inline.extras.modicon"), InlineClientConfigImpl.getInstance().shouldRenderModIcons()).setTooltip(new Component[]{Component.m_237115_((String)"config.inline.extras.modicon.desc")}).setDefaultValue(true).setYesNoTextSupplier(boolval -> boolval != false ? Component.m_237115_((String)"addServer.resourcePack.enabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)) : Component.m_237115_((String)"addServer.resourcePack.disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))).setSaveConsumer(enabled -> InlineClientConfigImpl.getInstance().setShouldRenderModIcons((boolean)enabled)).build();
        extraFeatures.addEntry((AbstractConfigListEntry)modIconEntry);
        DoubleListEntry chatCapField = entryBuilder.startDoubleField((Component)Component.m_237115_((String)"config.inline.extras.chatcap"), InlineClientConfigImpl.getInstance().maxChatSizeModifier()).setTooltip(new Component[]{Component.m_237115_((String)"config.inline.extras.chatcap.desc")}).setDefaultValue(1.5).setMin(1.0).setMax(2.0).setSaveConsumer(newCap -> InlineClientConfigImpl.getInstance().setChatScaleCap((double)newCap)).build();
        extraFeatures.addEntry((AbstractConfigListEntry)chatCapField);
        if (IModMeta.getMod("create").isPresent()) {
            BooleanListEntry createToggleEntry = entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.inline.extras.createinterop"), InlineClientConfigImpl.getInstance().shouldDoCreateMixins()).setTooltip(new Component[]{Component.m_237115_((String)"config.inline.extras.createinterop.desc")}).setDefaultValue(true).setYesNoTextSupplier(boolval -> boolval != false ? Component.m_237115_((String)"addServer.resourcePack.enabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)) : Component.m_237115_((String)"addServer.resourcePack.disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))).setSaveConsumer(enabled -> InlineClientConfigImpl.getInstance().setShouldDoCreateMixins((boolean)enabled)).build();
            extraFeatures.addEntry((AbstractConfigListEntry)createToggleEntry);
        }
        builder.setSavingRunnable(() -> InlineClientConfigImpl.getInstance().save());
        return builder.build();
    }

    private static AbstractConfigListEntry makeMatcherConfig(ConfigEntryBuilder entryBuilder, InlineMatcher matcher) {
        MatcherInfo info = matcher.getInfo();
        boolean matcherEnabled = InlineClientConfigImpl.getInstance().isMatcherEnabled(matcher.getId());
        return entryBuilder.startBooleanToggle(info.getTitle(matcherEnabled), matcherEnabled).setTooltip(new Component[]{info.getDescription()}).setDefaultValue(true).setYesNoTextSupplier(boolval -> boolval != false ? Component.m_237115_((String)"addServer.resourcePack.enabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)) : Component.m_237115_((String)"addServer.resourcePack.disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))).setSaveConsumer(enabled -> InlineClientConfigImpl.getInstance().someableMatcher(matcher.getId(), (boolean)enabled)).build();
    }
}

