/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatchContext;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class MatchContextImpl
implements MatchContext {
    private final String fullInput;
    private final Component fullInputText;
    private final TreeMap<Integer, InlineMatch> matchMap = new TreeMap();
    private final TreeMap<Integer, InlineMatch> singularMatchMap = new TreeMap();
    private final BitSet matchCheck;
    private Component finalStyledTextCached = null;
    private String finalTextCached = null;
    private Map<Integer, InlineMatch> finalMatchesCached = null;
    private boolean frozen = false;

    public MatchContextImpl(String fullInput) {
        this(Component.m_130674_((String)fullInput));
    }

    public MatchContextImpl(Component textInput) {
        this.fullInputText = textInput;
        this.fullInput = textInput.getString();
        this.matchCheck = new BitSet(this.fullInput.length());
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public String getOriginalText() {
        return this.fullInput;
    }

    @Override
    public String getMatchableText(char redactedChar) {
        StringBuilder resBuilder = new StringBuilder();
        for (int i = 0; i < this.fullInput.length(); ++i) {
            if (this.matchCheck.get(i)) {
                resBuilder.append(redactedChar);
                continue;
            }
            resBuilder.append(this.fullInput.charAt(i));
        }
        return resBuilder.toString();
    }

    @Override
    public boolean addMatch(int start, int end, InlineMatch match) {
        if (this.frozen) {
            return false;
        }
        int nextMatchIndex = this.matchCheck.nextSetBit(start);
        if (nextMatchIndex != -1 && nextMatchIndex < end) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            this.matchMap.put(i, match);
        }
        if (this.singularMatchMap.get(start - 1) != match) {
            this.singularMatchMap.put(start, match);
        }
        if (this.singularMatchMap.get(start + 1) == match) {
            this.singularMatchMap.remove(start + 1);
        }
        this.matchCheck.set(start, end);
        this.finalStyledTextCached = null;
        this.finalTextCached = null;
        this.finalMatchesCached = null;
        return true;
    }

    @Override
    public Component getFinalStyledText() {
        if (this.matchMap.isEmpty()) {
            return this.fullInputText.m_6881_();
        }
        if (this.finalStyledTextCached != null) {
            return this.finalStyledTextCached.m_6881_();
        }
        MutableComponent res = Component.m_237119_();
        AtomicReference<Object> currentMatch = new AtomicReference<Object>(null);
        AtomicInteger chunkIdx = new AtomicInteger(0);
        this.fullInputText.m_7451_((sty, seg) -> {
            for (int i = 0; i < seg.length(); ++i) {
                int absI = i + chunkIdx.get();
                if (this.matchCheck.get(absI)) {
                    InlineMatch newMatch = this.matchMap.get(absI);
                    if (newMatch == currentMatch.get()) continue;
                    newMatch.accept((vI, vSty, codePoint) -> {
                        res.m_7220_((Component)Component.m_237113_((String)Character.toString(codePoint)).m_6270_(vSty));
                        return true;
                    }, res.getString().length(), sty);
                    currentMatch.set(newMatch);
                    continue;
                }
                res.m_7220_((Component)Component.m_237113_((String)seg.substring(absI, absI + 1)).m_6270_(sty));
            }
            chunkIdx.addAndGet(seg.length());
            return Optional.empty();
        }, Style.f_131099_);
        this.finalStyledTextCached = res.m_6881_();
        return res;
    }

    @Override
    public String getFinalText() {
        if (this.matchMap.isEmpty()) {
            return this.fullInput;
        }
        if (this.finalTextCached != null) {
            return this.finalTextCached;
        }
        StringBuilder res = new StringBuilder();
        InlineMatch currentMatch = null;
        for (int i = 0; i < this.fullInput.length(); ++i) {
            if (this.matchCheck.get(i)) {
                InlineMatch newMatch = this.matchMap.get(i);
                if (newMatch == currentMatch) continue;
                int charCount = newMatch.charLength();
                res.append(String.join((CharSequence)"", Collections.nCopies(charCount, String.valueOf('.'))));
                currentMatch = newMatch;
                continue;
            }
            res.append(this.fullInput.charAt(i));
            currentMatch = null;
        }
        this.finalTextCached = res.toString();
        return this.finalTextCached;
    }

    @Override
    public Map<Integer, InlineMatch> getFinalMatches() {
        if (this.matchMap.isEmpty()) {
            return new HashMap<Integer, InlineMatch>();
        }
        if (this.finalMatchesCached != null) {
            return new TreeMap<Integer, InlineMatch>(this.finalMatchesCached);
        }
        int matchIndex = this.matchCheck.nextSetBit(0);
        TreeMap<Integer, InlineMatch> squishedMatchMap = new TreeMap<Integer, InlineMatch>();
        InlineMatch currentMatch = null;
        for (int i = matchIndex; i < this.fullInput.length(); ++i) {
            if (this.matchCheck.get(i)) {
                InlineMatch newMatch = this.matchMap.get(i);
                if (newMatch == currentMatch) continue;
                int charCount = newMatch.charLength();
                squishedMatchMap.put(matchIndex, newMatch);
                matchIndex += charCount;
                currentMatch = newMatch;
                continue;
            }
            ++matchIndex;
            currentMatch = null;
        }
        this.finalMatchesCached = squishedMatchMap;
        return squishedMatchMap;
    }

    @Override
    public Map<Integer, InlineMatch> getMatches() {
        return new TreeMap<Integer, InlineMatch>((SortedMap<Integer, InlineMatch>)this.singularMatchMap);
    }

    @Override
    public int origToFinal(int orig) {
        int unmatchedIsh = orig;
        if (this.matchCheck.get(orig)) {
            unmatchedIsh = this.singularMatchMap.floorKey(orig);
        }
        int prevMatchChars = this.matchCheck.get(0, unmatchedIsh).cardinality();
        int numMatches = this.singularMatchMap.subMap(0, unmatchedIsh).size();
        return unmatchedIsh - prevMatchChars + numMatches;
    }

    @Override
    public int finalToOrig(int fin) {
        int fCounted = 0;
        int i = 0;
        InlineMatch currentMatch = null;
        while (fCounted < fin) {
            InlineMatch newMatch = this.matchMap.get(i);
            if (newMatch == null) {
                currentMatch = null;
                ++fCounted;
            } else if (newMatch != currentMatch) {
                currentMatch = newMatch;
                ++fCounted;
            }
            ++i;
        }
        return i;
    }

    @Override
    public Map<Integer, String> getUnmatchedSequences() {
        int seqStart = this.matchCheck.nextClearBit(0);
        TreeMap<Integer, String> seqMap = new TreeMap<Integer, String>();
        while (seqStart != -1) {
            int seqEnd = this.matchCheck.nextSetBit(seqStart);
            String seq = this.fullInput.substring(seqStart, seqEnd == -1 ? this.fullInput.length() : seqEnd);
            seqMap.put(seqStart, seq);
            if (seqEnd == -1) {
                return seqMap;
            }
            seqStart = this.matchCheck.nextClearBit(seqEnd);
        }
        return seqMap;
    }

    public static class ChatMatchContextImpl
    extends MatchContextImpl
    implements MatchContext.ChatMatchContext {
        private final ServerPlayer player;

        public ChatMatchContextImpl(ServerPlayer player, Component originalMsg) {
            super(originalMsg);
            this.player = player;
        }

        @Override
        public ServerPlayer getChatSender() {
            return this.player;
        }
    }
}

