/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lazy.baubles.api.BaublesAPI;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.api.bauble.IBaublesItemHandler;
import lazy.baubles.api.cap.CapabilityBaubles;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class BaublesHandler {
    public static List<ItemStack> getBaublesMatchingSlot(Player player, ItemStack itemStack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!itemStack.getCapability(CapabilityBaubles.ITEM_BAUBLE).isPresent()) {
            return result;
        }
        IBauble bauble = (IBauble)itemStack.getCapability(CapabilityBaubles.ITEM_BAUBLE).resolve().get();
        Set baubleSlots = Arrays.stream(bauble.getBaubleType(itemStack).getValidSlots()).boxed().collect(Collectors.toSet());
        LazyOptional allBaubles = BaublesAPI.getBaublesHandler((Player)player);
        if (allBaubles.isPresent()) {
            for (int i = 0; i < ((IBaublesItemHandler)allBaubles.resolve().get()).getSlots(); ++i) {
                ItemStack stack = ((IBaublesItemHandler)allBaubles.resolve().get()).getStackInSlot(i);
                if (stack == ItemStack.f_41583_) continue;
                IBauble equippedBauble = (IBauble)stack.getCapability(CapabilityBaubles.ITEM_BAUBLE).resolve().get();
                Set sharedSlots = Arrays.stream(equippedBauble.getBaubleType(stack).getValidSlots()).boxed().collect(Collectors.toSet());
                sharedSlots.retainAll(baubleSlots);
                if (sharedSlots.isEmpty()) continue;
                result.add(stack);
            }
        }
        return result;
    }
}

