/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar;

import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import cgcm.chestsearchbar.search.ContainerSearcher;
import cgcm.chestsearchbar.util.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;

public class SearchHandler {
    public static String search = "";
    public static boolean enabled = true;
    private final AbstractContainerScreen<?> screen;
    private final EditBox searchBar;
    private final Mode mode;
    private List<Slot> slots = new ArrayList<Slot>();

    public SearchHandler(AbstractContainerScreen<?> screen, EditBox searchBax, Mode mode) {
        this.screen = screen;
        this.searchBar = searchBax;
        this.mode = mode;
        if (Config.keepSearch) {
            this.searchBar.m_94144_(search);
        }
        if (Config.autoFocus && enabled) {
            this.searchBar.m_93692_(true);
            screen.m_7522_((GuiEventListener)this.searchBar);
        }
        this.searchBar.m_94194_(enabled);
        this.searchBar.m_94151_(this::refreshAndUpdate);
    }

    public List<Slot> getSearchResult() {
        return this.slots;
    }

    public EditBox getSearchBar() {
        return this.searchBar;
    }

    public boolean isBarEmpty() {
        return this.searchBar.m_94155_().isEmpty();
    }

    public boolean shouldUseSearch() {
        return !this.isBarEmpty() && this.searchBar.m_94213_();
    }

    public int getMenuSize() {
        return ContainerUtil.getMenuSize(this.screen.m_6262_().f_38839_.size());
    }

    public void tick() {
        if (this.searchBar.m_94213_()) {
            this.searchBar.m_94120_();
            if (!this.isBarEmpty()) {
                this.refreshResults(this.searchBar.m_94155_());
            }
        }
    }

    public void refreshAndUpdate(String search) {
        SearchHandler.search = search;
        this.refreshResults(search);
    }

    public void refreshResults(String search) {
        this.slots = ContainerSearcher.search(search, this.screen.m_6262_(), this.getMenuSize());
        if (this.slots.isEmpty() && !this.isBarEmpty()) {
            this.searchBar.m_94202_(-39836);
        } else {
            this.searchBar.m_94202_(0xFFFFFF);
        }
    }

    public boolean isSortMode() {
        return this.mode == Mode.SORT;
    }
}

