/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.config;

import cgcm.chestsearchbar.api.ISearchable;
import cgcm.chestsearchbar.config.JsonConfig;
import cgcm.chestsearchbar.config.Mode;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public class Config {
    public static boolean keepSearch = true;
    public static boolean autoFocus = false;
    public static boolean detachSearchBar = false;
    public static Mode vanillaContainerMode = Mode.SORT;
    public static Map<String, Integer> modePerScreenMap = new HashMap<String, Integer>(){
        {
            this.put("compasses.expandedstorage.impl.client.gui.SingleScreen", 1);
            this.put("compasses.expandedstorage.impl.client.gui.PageScreen", 1);
            this.put("com.progwml6.ironchest.client.screen.IronChestScreen", 1);
            this.put("appeng.client.gui.implementations.SkyChestScreen", 2);
            this.put("fuzs.netherchested.client.gui.screens.inventory.NetherChestScreen", 2);
        }
    };
    public static final JsonConfig CLIENT_CONFIG = new JsonConfig();
    private static final JsonConfig.BooleanConfig KEEP_SEARCH = CLIENT_CONFIG.booleanBuilder("keepSearch", true);
    private static final JsonConfig.BooleanConfig AUTO_FOCUS = CLIENT_CONFIG.booleanBuilder("autoFocus", false);
    private static final JsonConfig.BooleanConfig DETACH_BAR = CLIENT_CONFIG.booleanBuilder("detachSearchBar", false);
    private static final JsonConfig.IntConfig VANILLA_MODE = (JsonConfig.IntConfig)CLIENT_CONFIG.intBuilder("vanillaContainerMode", Mode.SORT.ordinal(), 0, 2).description("Mode for minecraft containers. 0 = Disabled.");
    private static final JsonConfig.HashMapConfig MODE_PER_SCREEN = (JsonConfig.HashMapConfig)CLIENT_CONFIG.HashMapConfigBuilder("modePerScreen", modePerScreenMap, 0, 2).description("Mode for each screen. 0 = Disabled.");

    public static Mode getMode(AbstractContainerScreen<?> screen, int menuSize) {
        String className = screen.getClass().getName();
        if (className.equals("net.minecraft.client.gui.screens.inventory.ContainerScreen") || className.startsWith("net.minecraft.") && menuSize >= 27) {
            return vanillaContainerMode;
        }
        if (modePerScreenMap.containsKey(className)) {
            return Mode.values()[modePerScreenMap.get(className)];
        }
        if (screen instanceof ISearchable) {
            ISearchable searchable = (ISearchable)screen;
            return searchable.getMode();
        }
        return Mode.DISABLED;
    }

    public static void load(Path p) {
        CLIENT_CONFIG.load(p.resolve("chestsearchbar.json").toFile());
        keepSearch = (Boolean)KEEP_SEARCH.get();
        autoFocus = (Boolean)AUTO_FOCUS.get();
        detachSearchBar = (Boolean)DETACH_BAR.get();
        vanillaContainerMode = Mode.values()[(Integer)VANILLA_MODE.get()];
        modePerScreenMap = (Map)MODE_PER_SCREEN.get();
    }
}

