/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.mixin.client;

import cgcm.chestsearchbar.SearchHandler;
import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import cgcm.chestsearchbar.gui.SearchBox;
import cgcm.chestsearchbar.input.Keybindings;
import cgcm.chestsearchbar.util.ContainerUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected final T f_97732_;
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97728_;
    @Shadow
    protected int f_97729_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    protected Slot f_97734_;
    @Unique
    private SearchHandler searchHandler;
    @Unique
    private static long lastClick;

    @Shadow
    protected abstract boolean m_6774_(int var1, int var2, int var3, int var4, double var5, double var7);

    @Shadow
    protected abstract boolean m_97774_(Slot var1, double var2, double var4);

    protected AbstractContainerScreenMixin(T menu, Component pTitle) {
        super(pTitle);
        this.f_97732_ = menu;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo callbackinfo) {
        int pX;
        int barWidth;
        AbstractContainerScreen instance = (AbstractContainerScreen)this;
        Mode mode = Config.getMode(instance, ContainerUtil.getMenuSize(((AbstractContainerMenu)this.f_97732_).f_38839_.size()));
        if (instance instanceof CreativeModeInventoryScreen || instance instanceof InventoryScreen || instance instanceof CraftingScreen || mode == Mode.DISABLED) {
            return;
        }
        int pY = this.f_97736_ + this.f_97729_;
        if (Config.detachSearchBar) {
            barWidth = (int)((double)this.f_97726_ * 0.6);
            pX = this.f_96543_ / 2 - barWidth / 2;
            pY = Math.max(pY - 20, 1);
        } else {
            pX = this.f_97735_ + this.f_97728_ + (this.f_96539_.getString().isBlank() ? 0 : this.f_96547_.m_92895_(this.f_96539_.getString().replaceAll("\\p{C}", "")) + 3);
            int finalPos = this.f_97735_ + this.f_97726_ - this.f_97728_;
            pX = Math.min(pX, finalPos - 32);
            barWidth = finalPos - pX + 1;
        }
        SearchBox searchBar = new SearchBox(this.f_96547_, pX + 1, pY, barWidth, 9, Config.detachSearchBar);
        this.searchHandler = new SearchHandler(instance, searchBar, mode);
        this.m_7787_((GuiEventListener)searchBar);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler == null) {
            return;
        }
        this.searchHandler.getSearchBar().m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!this.searchHandler.shouldUseSearch() || !this.searchHandler.isSortMode()) {
            return;
        }
        for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
            Slot posSlot = this.f_97732_.m_38853_(i);
            if (!this.m_6774_(posSlot.f_40220_, posSlot.f_40221_, 16, 16, pMouseX, pMouseY) || !posSlot.m_6659_()) continue;
            this.f_97734_ = i < this.searchHandler.getSearchResult().size() ? this.searchHandler.getSearchResult().get(i) : null;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    private void onRenderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler != null && this.searchHandler.shouldUseSearch() && !this.searchHandler.isSortMode()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                Slot posSlot = this.f_97732_.m_38853_(i);
                if (this.searchHandler.getSearchResult().contains(posSlot)) continue;
                pGuiGraphics.m_285978_(RenderType.m_286086_(), posSlot.f_40220_, posSlot.f_40221_, posSlot.f_40220_ + 16, posSlot.f_40221_ + 16, -1275068416, -1275068416, 0);
            }
        }
    }

    @Redirect(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;getItem()Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack redirectGetItem(Slot slot) {
        int index = slot.f_40219_;
        if (this.searchHandler == null || !this.searchHandler.shouldUseSearch() || !this.searchHandler.isSortMode() || index >= this.searchHandler.getMenuSize()) {
            return slot.m_7993_();
        }
        if (this.searchHandler.getSearchResult().size() > index) {
            return this.searchHandler.getSearchResult().get(index).m_7993_();
        }
        return ItemStack.f_41583_;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (!this.searchHandler.getSearchBar().m_5953_(pMouseX, pMouseY)) {
                this.searchHandler.getSearchBar().m_93692_(false);
            } else {
                long time = System.currentTimeMillis();
                long d = time - lastClick;
                if (d < 200L && this.searchHandler.getSearchBar().m_93696_() && !this.searchHandler.isBarEmpty()) {
                    this.searchHandler.getSearchBar().m_94144_("");
                    SearchHandler.search = "";
                }
                lastClick = time;
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (this.searchHandler.getSearchBar().m_93696_()) {
                if (pKeyCode != 256 && this.searchHandler.getSearchBar().m_94213_()) {
                    this.searchHandler.getSearchBar().m_7933_(pKeyCode, pScanCode, pModifiers);
                    cir.setReturnValue((Object)true);
                }
            } else if (Keybindings.TOGGLE_SEARCH_BAR_KEY.m_90832_(pKeyCode, pScanCode)) {
                boolean v = !this.searchHandler.getSearchBar().m_94213_();
                this.searchHandler.getSearchBar().m_94194_(v);
                SearchHandler.enabled = v;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.searchHandler != null) {
            this.searchHandler.tick();
        }
    }

    @Inject(method={"findSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void findSlot(double pMouseX, double pMouseY, CallbackInfoReturnable<Slot> cir) {
        if (this.searchHandler != null && this.searchHandler.isSortMode() && this.searchHandler.shouldUseSearch()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                Slot slot = this.f_97732_.m_38853_(i);
                if (!this.m_97774_(slot, pMouseX, pMouseY) || !slot.m_6659_()) continue;
                if (i < this.searchHandler.getSearchResult().size()) {
                    cir.setReturnValue((Object)this.searchHandler.getSearchResult().get(i));
                    continue;
                }
                cir.setReturnValue(null);
            }
        }
    }
}

