/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.Lang;
import edn.stratodonut.trackwork.TrackEntityTypes;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.TrackworkMod;
import edn.stratodonut.trackwork.tracks.ITrackPointProvider;
import edn.stratodonut.trackwork.tracks.TrackBeltEntity;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlockEntity;
import edn.stratodonut.trackwork.tracks.data.PhysEntityTrackData;
import edn.stratodonut.trackwork.tracks.forces.PhysEntityTrackController;
import edn.stratodonut.trackwork.wheel.WheelEntity;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.constraints.VSHingeOrientationConstraint;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityData;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class PhysEntityTrackBlockEntity
extends TrackBaseBlockEntity
implements ITrackPointProvider {
    private float wheelRadius = 0.5f;
    protected final Supplier<Ship> ship = () -> VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)pos);
    private Integer trackID;
    private UUID wheelID;
    @NotNull
    private WeakReference<WheelEntity> wheel = new WeakReference<Object>(null);
    public boolean assembled = false;
    public boolean assembleNextTick = true;

    public PhysEntityTrackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(40);
    }

    public static PhysEntityTrackBlockEntity large(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        PhysEntityTrackBlockEntity be = new PhysEntityTrackBlockEntity(type, pos, state);
        be.wheelRadius = 1.0f;
        return be;
    }

    public static PhysEntityTrackBlockEntity med(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        PhysEntityTrackBlockEntity be = new PhysEntityTrackBlockEntity(type, pos, state);
        be.wheelRadius = 0.75f;
        return be;
    }

    public void destroy() {
        ServerShip ship;
        super.destroy();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.assembled && (ship = (ServerShip)this.ship.get()) != null) {
            PhysEntityTrackController controller = PhysEntityTrackController.getOrCreate(ship);
            controller.removeTrackBlock((ServerLevel)this.f_58857_, this.trackID);
            Objects.requireNonNull((WheelEntity)((Object)this.wheel.get())).m_6074_();
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_ && this.assembled) {
            Entity e = ((ServerLevel)this.f_58857_).m_8791_(this.wheelID);
            ServerShip ship = (ServerShip)this.ship.get();
            if (ship != null) {
                if (e instanceof WheelEntity) {
                    WheelEntity wheel = (WheelEntity)e;
                    if (this.constrainWheel(ship, wheel.getShipId(), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))) != null) {
                        return;
                    }
                    this.wheel = new WeakReference<WheelEntity>(wheel);
                } else {
                    this.assemble();
                    return;
                }
            }
            this.assembled = false;
            this.assembleNextTick = true;
        }
    }

    @Deprecated
    public boolean summonBelt() {
        if (!this.f_58857_.f_46443_) {
            TrackBeltEntity e = TrackBeltEntity.create(this.f_58857_, this.m_58899_());
            e.m_146884_(Vec3.m_82528_((Vec3i)this.m_58899_()));
            this.f_58857_.m_7967_((Entity)e);
        }
        return true;
    }

    private void assemble() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!TrackBaseBlock.isValidAxis((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS))) {
                return;
            }
            ServerLevel slevel = (ServerLevel)this.f_58857_;
            ServerShip ship = (ServerShip)this.ship.get();
            if (ship != null) {
                PhysEntityTrackController controller = PhysEntityTrackController.getOrCreate(ship);
                if (this.assembled) {
                    controller.removeTrackBlock((ServerLevel)this.f_58857_, this.trackID);
                }
                this.assembled = true;
                Vector3d trackLocalPos = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()));
                WheelEntity wheel = (WheelEntity)TrackEntityTypes.WHEEL.create((Level)slevel);
                long wheelId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)slevel).allocateShipId(VSGameUtilsKt.getDimensionId((Level)slevel));
                double wheelRadius = this.wheelRadius;
                Vector3d wheelGlobalPos = ship.getTransform().getShipToWorld().transformPosition((Vector3dc)trackLocalPos, new Vector3d());
                ShipTransform transform = ShipTransformImpl.Companion.create((Vector3dc)wheelGlobalPos, (Vector3dc)new Vector3d());
                PhysicsEntityData wheelData = WheelEntity.DataBuilder.createBasicData(wheelId, transform, wheelRadius, 1000.0);
                wheel.setPhysicsEntityData(wheelData);
                wheel.m_146884_(VectorConversionsMCKt.toMinecraft((Vector3dc)wheelGlobalPos));
                slevel.m_7967_((Entity)wheel);
                PhysEntityTrackData.CreateData createData = this.constrainWheel(ship, wheelId, (Vector3dc)trackLocalPos);
                this.trackID = controller.addTrackBlock(createData);
                this.wheelID = wheel.m_20148_();
                this.wheel = new WeakReference<WheelEntity>(wheel);
                this.sendData();
            }
        }
    }

    private PhysEntityTrackData.CreateData constrainWheel(ServerShip ship, long wheelId, Vector3dc trackLocalPos) {
        ServerLevel slevel = (ServerLevel)this.f_58857_;
        double attachCompliance = 1.0E-8;
        double attachMaxForce = 1.0E150;
        double hingeMaxForce = 1.0E75;
        Vector3d axis = PhysEntityTrackBlockEntity.getAxisAsVec((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS));
        VSAttachmentConstraint slider = new VSAttachmentConstraint(ship.getId(), wheelId, attachCompliance, trackLocalPos, (Vector3dc)new Vector3d(0.0, 0.0, 0.0), attachMaxForce, 0.0);
        VSHingeOrientationConstraint axle = new VSHingeOrientationConstraint(ship.getId(), wheelId, attachCompliance, (Quaterniondc)new Quaterniond().fromAxisAngleDeg((Vector3dc)axis, 0.0), (Quaterniondc)new Quaterniond().fromAxisAngleDeg((Vector3dc)new Vector3d(0.0, 0.0, 1.0), 0.0), hingeMaxForce);
        Integer sliderId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)slevel).createNewConstraint((VSConstraint)slider);
        Integer axleId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)slevel).createNewConstraint((VSConstraint)axle);
        if (sliderId == null || axleId == null) {
            return null;
        }
        PhysEntityTrackData.CreateData trackData = new PhysEntityTrackData.CreateData(trackLocalPos, (Vector3dc)axis, wheelId, 0.0, 0.0, new VSConstraintAndId(sliderId.intValue(), (VSConstraint)slider), new VSConstraintAndId(axleId.intValue(), (VSConstraint)axle), this.getSpeed());
        return trackData;
    }

    @Override
    public void tick() {
        ServerShip ship;
        super.tick();
        if (this.ship.get() != null && this.assembleNextTick && !this.assembled && this.f_58857_ != null) {
            this.assemble();
            this.assembleNextTick = false;
            return;
        }
        if (this.f_58857_ == null) {
            TrackworkMod.warn("Level is null????", new Object[0]);
            return;
        }
        if (this.assembled && !this.f_58857_.f_46443_ && (ship = (ServerShip)this.ship.get()) != null) {
            WheelEntity wheel = (WheelEntity)((Object)this.wheel.get());
            if (wheel == null || !wheel.m_6084_() || wheel.m_213877_()) {
                this.assemble();
                wheel = (WheelEntity)((Object)this.wheel.get());
            } else {
                double distance = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))).distance((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)wheel.m_20182_()));
                if (distance > 8.0) {
                    this.assemble();
                    wheel = (WheelEntity)((Object)this.wheel.get());
                }
            }
            if (wheel == null) {
                TrackworkMod.warn("Wheel is NULL after assembly! At %s", this.m_58899_().toString());
                return;
            }
            wheel.keepAlive();
            PhysEntityTrackController controller = PhysEntityTrackController.getOrCreate(ship);
            PhysEntityTrackData.UpdateData data = new PhysEntityTrackData.UpdateData(0.0, 0.0, this.getSpeed());
            controller.updateTrackBlock(this.trackID, data);
        }
    }

    public void addMassStats(List<Component> tooltip, float mass) {
        Lang.text((String)"Total Mass").style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.number((double)mass).text(" kg").style(ChatFormatting.WHITE).forGoggles(tooltip, 1);
    }

    @Override
    public float getPointDownwardOffset(float partialTicks) {
        return (float)((double)this.wheelRadius - 0.5);
    }

    @Override
    public float getPointHorizontalOffset() {
        return 0.0f;
    }

    @Override
    public boolean isBeltLarge() {
        return (double)this.wheelRadius > 0.75;
    }

    @Override
    public Vec3 getTrackPointSlope(float partialTicks) {
        return new Vec3(0.0, (double)(Mth.m_14179_((float)partialTicks, (float)((Float)this.nextPointVerticalOffset.getFirst()).floatValue(), (float)((Float)this.nextPointVerticalOffset.getSecond()).floatValue()) - this.getPointDownwardOffset(partialTicks)), (double)this.nextPointHorizontalOffset);
    }

    @Override
    @NotNull
    public ITrackPointProvider.PointType getTrackPointType() {
        return ITrackPointProvider.PointType.WRAP;
    }

    @Override
    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getSpeed() {
        if (!this.assembled) {
            return 0.0f;
        }
        return Math.min(super.getSpeed(), (float)((Integer)TrackworkConfigs.server().maxRPM.get()).intValue());
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Assembled", this.assembled);
        if (this.trackID != null) {
            compound.m_128405_("trackBlockID", this.trackID.intValue());
        }
        if (this.wheelID != null) {
            compound.m_128362_("wheelID", this.wheelID);
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.assembled = compound.m_128471_("Assembled");
        if (this.trackID == null && compound.m_128441_("trackBlockID")) {
            this.trackID = compound.m_128451_("trackBlockID");
        }
        if (this.wheelID == null && compound.m_128403_("wheelID")) {
            this.wheelID = compound.m_128342_("wheelID");
        }
        super.read(compound, clientPacket);
    }

    public float calculateStressApplied() {
        float impact;
        if (this.f_58857_.f_46443_ || !((Boolean)TrackworkConfigs.server().enableStress.get()).booleanValue() || !this.assembled || this.m_58900_().m_61143_(TrackBaseBlock.PART) != TrackBaseBlock.TrackPart.START) {
            return super.calculateStressApplied();
        }
        Ship ship = this.ship.get();
        if (ship == null) {
            return super.calculateStressApplied();
        }
        double mass = ((ServerShip)ship).getInertiaData().getMass();
        this.lastStressApplied = impact = this.calculateStressApplied((float)mass);
        return impact;
    }

    public float calculateStressApplied(float mass) {
        double impact = (double)(mass / 1000.0f) * (Double)TrackworkConfigs.server().stressMult.get() * (double)(2.0f * this.wheelRadius);
        if (impact < 0.0) {
            impact = 0.0;
        }
        return (float)impact;
    }
}

