/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.infrastructure.config.AllConfigs;
import edn.stratodonut.trackwork.TrackDamageSources;
import edn.stratodonut.trackwork.TrackPackets;
import edn.stratodonut.trackwork.TrackSounds;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.ducks.MSGPLIDuck;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlock;
import edn.stratodonut.trackwork.tracks.data.SimpleWheelData;
import edn.stratodonut.trackwork.tracks.forces.SimpleWheelController;
import edn.stratodonut.trackwork.tracks.network.SimpleWheelPacket;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class WheelBlockEntity
extends KineticBlockEntity {
    private float wheelRadius = 1.0f;
    private float suspensionTravel = 1.5f;
    private double suspensionScale = 1.0;
    private float steeringValue = 0.0f;
    private float linkedSteeringValue = 0.0f;
    protected final Random random = new Random();
    private float wheelTravel;
    private float prevWheelTravel;
    private float prevFreeWheelAngle;
    private float horizontalOffset;
    @NotNull
    protected final Supplier<Ship> ship = () -> VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)pos);
    public boolean isFreespin = true;
    public boolean assembled;
    public boolean assembleNextTick = true;

    public WheelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(40);
    }

    public void remove() {
        ServerShip ship;
        super.remove();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.assembled && (ship = (ServerShip)this.ship.get()) != null) {
            SimpleWheelController controller = SimpleWheelController.getOrCreate(ship);
            controller.removeTrackBlock(this.m_58899_());
        }
    }

    private void assemble() {
        ServerShip ship;
        if (!WheelBlock.isValid((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING))) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (ship = (ServerShip)this.ship.get()) != null && Math.abs((double)(1.0 - ship.getTransform().getShipToWorldScaling().length())) > 0.01) {
            this.assembled = true;
            SimpleWheelController controller = SimpleWheelController.getOrCreate(ship);
            SimpleWheelData.SimpleWheelCreateData data = new SimpleWheelData.SimpleWheelCreateData((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_())));
            controller.addTrackBlock(this.m_58899_(), data);
            this.sendData();
        }
    }

    public void tick() {
        KineticBlock ke;
        Block speed;
        super.tick();
        if (this.ship.get() != null && this.assembleNextTick && !this.assembled && this.f_58857_ != null) {
            this.assemble();
            this.assembleNextTick = false;
            return;
        }
        if (this.f_58857_.f_46443_ && this.ship.get() != null && Math.abs((float)this.getSpeed()) > 64.0f) {
            Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_()));
            Vector3d ground = VSGameUtilsKt.getWorldCoordinates((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Vector3d)pos.sub((Vector3dc)SimpleWheelController.UP.mul((double)this.wheelTravel * 1.2, new Vector3d())));
            BlockPos blockpos = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)ground));
            BlockState blockstate = this.f_58857_.m_8055_(blockpos);
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                speed = this.ship.get().getShipTransform().getShipToWorldRotation().transform(TrackBaseBlockEntity.getActionVec3d(((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_(), this.getSpeed()));
                this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), pos.x + (this.random.nextDouble() - 0.5), pos.y + 0.25, pos.z + (this.random.nextDouble() - 0.5) * (double)this.wheelRadius, speed.x() * -1.0, 10.5, speed.z() * -1.0);
            }
        }
        Direction dir = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockPos innerBlock = this.m_58899_().m_121945_(dir);
        BlockState innerState = this.f_58857_.m_8055_(innerBlock);
        speed = innerState.m_60734_();
        if (speed instanceof KineticBlock && (ke = (KineticBlock)speed).hasShaftTowards((LevelReader)this.f_58857_, this.m_58899_(), innerState, dir.m_122424_())) {
            this.isFreespin = false;
        } else {
            this.isFreespin = true;
            if (this.f_58857_.f_46443_) {
                this.prevFreeWheelAngle += this.getWheelSpeed() * 3.0f / 10.0f;
            }
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.assembled) {
            Vec3 start = Vec3.m_82512_((Vec3i)this.m_58899_());
            Direction.Axis axis = dir.m_122434_();
            double restOffset = this.wheelRadius - 0.5f;
            float trackRPM = this.getSpeed();
            double susScaled = (double)this.suspensionTravel * this.suspensionScale;
            ServerShip ship = (ServerShip)this.ship.get();
            if (ship != null) {
                BlockState b;
                Vec3 worldSpaceNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)WheelBlockEntity.getActionNormal(axis)), new Vector3d()).mul(susScaled + 0.5));
                Vec3 worldSpaceStart = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)start.m_82520_(0.0, -restOffset, 0.0))));
                int bestSignal = this.f_58857_.m_277086_(this.m_58899_());
                this.steeringValue = (float)bestSignal / 15.0f * (float)(dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1);
                this.onLinkedWheel(wbe -> {
                    wbe.linkedSteeringValue = this.steeringValue;
                });
                Vector3d worldSpaceForward = ship.getTransform().getShipToWorldRotation().transform((Vector3dc)this.getActionVec3d(axis, 1.0f), new Vector3d());
                float horizontalOffset = this.getPointHorizontalOffset();
                Vec3 worldSpaceFutureOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)worldSpaceForward.normalize(Math.clamp((double)(-0.4 - (double)horizontalOffset), (double)(0.4 - (double)horizontalOffset), (double)(0.05 * ship.getVelocity().dot((Vector3dc)worldSpaceForward))), new Vector3d()));
                Vec3 worldSpaceHorizontalOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)this.getForwardVec3d(axis, 1.0f), new Vector3d()).mul((double)horizontalOffset, new Vector3d()));
                ClipResult clipResult = this.clipAndResolve(ship, axis, worldSpaceStart.m_82549_(worldSpaceHorizontalOffset).m_82549_(worldSpaceFutureOffset), worldSpaceNormal);
                Vector3d forceVec = clipResult.trackTangent.mul((double)this.wheelRadius / 0.5, new Vector3d());
                if (forceVec.lengthSquared() == 0.0 && (b = this.f_58857_.m_8055_(BlockPos.m_274446_((Position)worldSpaceStart))).m_60819_().m_205070_(FluidTags.f_13131_)) {
                    forceVec = ship.getTransform().getShipToWorldRotation().transform(this.getActionVec3d(axis, 1.0f)).mul((double)this.wheelRadius / 0.5).mul(0.2);
                }
                double suspensionTravel = clipResult.suspensionLength.m_82556_() == 0.0 ? susScaled : clipResult.suspensionLength.m_82553_() - 0.5;
                Vector3d suspensionForce = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal.m_82490_(susScaled - suspensionTravel)).negate();
                SimpleWheelController controller = SimpleWheelController.getOrCreate(ship);
                SimpleWheelData.SimpleWheelUpdateData data = new SimpleWheelData.SimpleWheelUpdateData((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceHorizontalOffset)), (Vector3dc)forceVec, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal), (Vector3dc)suspensionForce, this.isFreespin, clipResult.groundShipId, clipResult.suspensionLength.m_82556_() != 0.0, trackRPM);
                this.suspensionScale = controller.updateTrackBlock(this.m_58899_(), data);
                float newWheelTravel = (float)(suspensionTravel + restOffset);
                float delta = newWheelTravel - this.wheelTravel;
                if ((double)delta < -0.667) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)TrackSounds.SUSPENSION_CREAK.get(), SoundSource.BLOCKS, Math.max((float)1.0f, (float)Math.abs((float)(delta * (this.getWheelSpeed() / 256.0f)))), 0.8f + 0.4f * this.random.nextFloat());
                }
                this.prevWheelTravel = this.wheelTravel;
                this.wheelTravel = newWheelTravel;
                TrackPackets.getChannel().send(this.packetTarget(), (Object)new SimpleWheelPacket(this.m_58899_(), this.wheelTravel, this.getSteeringValue(), this.horizontalOffset));
                List hits = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_()).m_82363_(0.0, -1.0, 0.0).m_82406_(0.5));
                Vec3 worldPos = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))));
                for (LivingEntity e : hits) {
                    SuspensionTrackBlockEntity.push((Entity)e, worldPos);
                    if (e instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)e;
                        ((MSGPLIDuck)p.f_8906_).tallyho$setAboveGroundTickCount(0);
                    }
                    Vec3 relPos = e.m_20182_().m_82546_(worldPos);
                    float speed2 = Math.abs((float)this.getSpeed());
                    if (!(speed2 > 1.0f)) continue;
                    e.m_6469_(TrackDamageSources.runOver(this.f_58857_), speed2 / 16.0f * (float)((Integer)AllConfigs.server().kinetics.crushingDamage.get()).intValue());
                }
            }
        }
    }

    @NotNull
    private ClipResult clipAndResolve(ServerShip ship, Direction.Axis axis, Vec3 start, Vec3 dir) {
        BlockHitResult bResult = this.f_58857_.m_45547_(new ClipContext(start, start.m_82549_(dir), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (bResult.m_82436_()) {
            // empty if block
        }
        if (bResult.m_6662_() != HitResult.Type.BLOCK) {
            return new ClipResult((Vector3dc)new Vector3d(0.0), Vec3.f_82478_, null);
        }
        LoadedShip hitShip = VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)bResult.m_82425_());
        Long hitShipId = null;
        if (hitShip != null) {
            if (hitShip.equals(ship)) {
                return new ClipResult((Vector3dc)new Vector3d(0.0), Vec3.f_82478_, null);
            }
            hitShipId = hitShip.getId();
        }
        Vec3 worldSpacehitExact = bResult.m_82450_();
        Vec3 forceNormal = start.m_82546_(worldSpacehitExact);
        Vec3 worldSpaceAxis = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform(this.getAxisAsVec(axis).rotateAxis((double)(this.getSteeringValue() * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0)));
        return new ClipResult((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceAxis.m_82537_(forceNormal)).normalize(), forceNormal, hitShipId);
    }

    protected void onLinkedWheel(Consumer<WheelBlockEntity> action) {
        Direction dir = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        for (int i = 1; i <= 6; ++i) {
            BlockPos bpos = this.m_58899_().m_5484_(dir, i);
            BlockEntity be = this.f_58857_.m_7702_(bpos);
            if (!(be instanceof WheelBlockEntity)) continue;
            WheelBlockEntity wbe = (WheelBlockEntity)be;
            action.accept(wbe);
            break;
        }
    }

    protected static Vec3 getActionNormal(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3(0.0, -1.0, 0.0);
            case Direction.Axis.Y -> new Vec3(0.0, 0.0, 0.0);
            case Direction.Axis.Z -> new Vec3(0.0, -1.0, 0.0);
        };
    }

    protected Vector3d getAxisAsVec(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vector3d(1.0, 0.0, 0.0);
            case Direction.Axis.Y -> new Vector3d(0.0, 1.0, 0.0);
            case Direction.Axis.Z -> new Vector3d(0.0, 0.0, 1.0);
        };
    }

    public Vector3d getActionVec3d(Direction.Axis axis, float length) {
        return this.getForwardVec3d(axis, length).rotateAxis((double)(this.getSteeringValue() * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0);
    }

    public Vector3d getForwardVec3d(Direction.Axis axis, float length) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vector3d(0.0, 0.0, (double)length);
            case Direction.Axis.Y -> new Vector3d(0.0, 0.0, 0.0);
            case Direction.Axis.Z -> new Vector3d((double)length, 0.0, 0.0);
        };
    }

    public float getFreeWheelAngle(float partialTick) {
        return (this.prevFreeWheelAngle + this.getWheelSpeed() * partialTick * 3.0f / 10.0f) % 360.0f;
    }

    public float getWheelSpeed() {
        Ship s;
        if (this.isFreespin && (s = this.ship.get()) != null) {
            Vector3d vel = s.getVelocity().add((Vector3dc)s.getOmega().cross((Vector3dc)s.getShipToWorld().transformPosition((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_())), new Vector3d()).sub(s.getTransform().getPositionInWorld(), new Vector3d()), new Vector3d()), new Vector3d());
            Direction.Axis axis = ((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_();
            int sign = axis == Direction.Axis.X ? 1 : -1;
            return (float)sign * (float)TrackworkUtil.roundTowardZero(vel.dot((Vector3dc)s.getShipToWorld().transformDirection(this.getActionVec3d(axis, 1.0f))) * (double)9.3f);
        }
        return this.getSpeed();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Assembled", this.assembled);
        compound.m_128350_("WheelTravel", this.wheelTravel);
        compound.m_128350_("HorizontalOffset", this.horizontalOffset);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.assembled = compound.m_128471_("Assembled");
        this.wheelTravel = compound.m_128457_("WheelTravel");
        this.horizontalOffset = compound.m_128457_("HorizontalOffset");
        this.prevWheelTravel = this.wheelTravel;
        super.read(compound, clientPacket);
    }

    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getWheelTravel(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevWheelTravel, (float)this.wheelTravel);
    }

    public void setSteeringValue(float value) {
        this.steeringValue = value;
    }

    public float getSteeringValue() {
        return Math.abs((float)this.linkedSteeringValue) > Math.abs((float)this.steeringValue) ? this.linkedSteeringValue : this.steeringValue;
    }

    public void setHorizontalOffset(Vector3dc offset) {
        Direction.Axis axis = ((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_();
        double factor = offset.dot((Vector3dc)this.getActionVec3d(axis, 1.0f));
        this.horizontalOffset = Math.clamp((float)-0.4f, (float)0.4f, (float)((float)Math.round((double)(factor * 8.0)) / 8.0f));
        this.onLinkedWheel(wbe -> {
            wbe.horizontalOffset = this.horizontalOffset;
        });
    }

    public float getPointHorizontalOffset() {
        return this.horizontalOffset;
    }

    public float calculateStressApplied() {
        float impact;
        if (this.f_58857_.f_46443_ || !((Boolean)TrackworkConfigs.server().enableStress.get()).booleanValue() || !this.assembled) {
            return super.calculateStressApplied();
        }
        Ship ship = this.ship.get();
        if (ship == null) {
            return super.calculateStressApplied();
        }
        double mass = ((ServerShip)ship).getInertiaData().getMass();
        this.lastStressApplied = impact = this.calculateStressApplied((float)mass);
        return impact;
    }

    public float calculateStressApplied(float mass) {
        double impact = (double)(mass / 1000.0f) * (Double)TrackworkConfigs.server().stressMult.get() * (double)(2.0f * this.wheelRadius);
        if (impact < 0.0) {
            impact = 0.0;
        }
        return (float)impact;
    }

    public void handlePacket(SimpleWheelPacket p) {
        this.prevWheelTravel = this.wheelTravel;
        this.wheelTravel = p.wheelTravel;
        this.steeringValue = p.steeringValue;
        this.horizontalOffset = p.horizontalOffset;
    }

    public record ClipResult(Vector3dc trackTangent, Vec3 suspensionLength, @Nullable Long groundShipId) {
    }
}

