/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlock;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.render.TrackBeltRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SuspensionRenderer
extends KineticBlockEntityRenderer<SuspensionTrackBlockEntity> {
    public SuspensionRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(SuspensionTrackBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float yRot;
        BlockState state = be.m_58900_();
        Direction.Axis rotationAxis = SuspensionRenderer.getRotationAxisOf((KineticBlockEntity)be);
        BlockPos visualPos = be.m_58899_();
        float angleForBE = SuspensionRenderer.getAngleForBE(be, visualPos, rotationAxis);
        Direction.Axis trackAxis = (Direction.Axis)state.m_61143_((Property)TrackBaseBlock.AXIS);
        if (trackAxis == Direction.Axis.X) {
            angleForBE *= -1.0f;
        }
        float f = yRot = trackAxis == Direction.Axis.X ? 0.0f : 90.0f;
        if (state.m_61138_(SuspensionTrackBlock.WHEEL_VARIANT) && state.m_61143_(SuspensionTrackBlock.WHEEL_VARIANT) != SuspensionTrackBlock.TrackVariant.BLANK) {
            SuperByteBuffer wheels = be.getWheelRadius() < 0.6f ? CachedBufferer.partial((PartialModel)TrackworkPartialModels.SUSPENSION_WHEEL, (BlockState)state) : (be.getWheelRadius() > 0.8f ? CachedBufferer.partial((PartialModel)TrackworkPartialModels.LARGE_SUSPENSION_WHEEL, (BlockState)state) : CachedBufferer.partial((PartialModel)TrackworkPartialModels.MED_SUSPENSION_WHEEL, (BlockState)state));
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)wheels.centre()).rotateY((double)yRot)).translate(0.0, (double)be.getWheelRadius() - 0.5, 0.0).translate(0.0, (double)(-be.getWheelTravel(partialTicks)), (double)be.getPointHorizontalOffset()).rotateX((double)(-angleForBE))).translate(0.0, 0.5625, 0.0).unCentre();
            wheels.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
        if (be.assembled) {
            TrackBeltRenderer.renderBelt(be, partialTicks, ms, buffer, light, new TrackBeltRenderer.ScalableScroll(be, (float)((double)be.getSpeed() * ((double)be.getWheelRadius() / 0.5)), trackAxis));
        }
    }

    public static float getAngleForBE(KineticBlockEntity be, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float offset = SuspensionRenderer.getRotationOffsetForPosition((KineticBlockEntity)be, (BlockPos)pos, (Direction.Axis)axis);
        return (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f;
    }

    protected BlockState getRenderedBlockState(SuspensionTrackBlockEntity be) {
        return SuspensionRenderer.shaft((Direction.Axis)SuspensionRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public int m_142163_() {
        return (Integer)TrackworkConfigs.client().trackRenderDist.get();
    }
}

