/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.wheel;

import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityData;
import org.valkyrienskies.core.apigame.physics.VSCollisionShapeData;
import org.valkyrienskies.core.apigame.physics.VSWheelCollisionShapeData;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;
import org.valkyrienskies.mod.common.entity.VSPhysicsEntity;

public class WheelEntity
extends VSPhysicsEntity {
    int timeout = 0;

    public WheelEntity(@NotNull EntityType<? extends VSPhysicsEntity> type, @NotNull Level level) {
        super(type, level);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose p_19975_) {
        return new EntityDimensions(0.01f, 0.01f, false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        ++this.timeout;
        if (this.timeout > 60) {
            this.m_6074_();
        }
    }

    public long getShipId() {
        if (this.getPhysicsEntityData() == null) {
            return -1L;
        }
        return this.getPhysicsEntityData().getShipId();
    }

    public void keepAlive() {
        this.timeout = 0;
    }

    public static final class DataBuilder {
        private DataBuilder() {
        }

        @NotNull
        public static PhysicsEntityData createBasicData(long shipId, @NotNull ShipTransform transform, double radius, double mass) {
            double inertia = 0.4 * mass * radius * radius;
            ShipInertiaDataImpl inertiaData = new ShipInertiaDataImpl(new Vector3d(), mass * radius, new Matrix3d().scale(inertia));
            VSWheelCollisionShapeData collisionShapeData = new VSWheelCollisionShapeData(radius, 0.45, (int)(11.0 * radius));
            return new PhysicsEntityData(shipId, transform, (ShipInertiaData)inertiaData, (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), (VSCollisionShapeData)collisionShapeData, -1, 0.8, 0.6, 0.6, false);
        }
    }
}

