/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCookingRecipeBuilder
implements RecipeBuilder {
    protected final Item result;
    protected final int count;
    protected final Ingredient ingredient;
    protected final float experience;
    protected final int cookingTime;
    protected final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public AbstractCookingRecipeBuilder(ItemLike result, int count, Ingredient ingredient, float experience, int cookingTime) {
        this.result = result.m_5456_();
        this.count = count;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this;
    }

    public RecipeBuilder m_126145_(String group) {
        throw new IllegalStateException("Group not allow");
    }

    public Item m_142372_() {
        return this.result;
    }

    public static abstract class AbstractResult
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final Ingredient ingredient;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public AbstractResult(ResourceLocation id, Item result, int count, Ingredient ingredient, float experience, int cookingTime, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.ingredient = ingredient;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public final void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultJson);
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingTime", (Number)this.cookingTime);
            this.addJsonProperty(json);
        }

        protected void addJsonProperty(JsonObject json) {
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

