/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.gui.widget.FluidGaugeWidget;
import mods.railcraft.util.HumanReadableNumberFormatter;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.WaterCollectionModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class WaterCollectionGaugeWidget
extends FluidGaugeWidget {
    private final Collection<WaterCollectionModule> modules;
    private List<Component> tooltip;

    public WaterCollectionGaugeWidget(Collection<WaterCollectionModule> modules, StandardTank tank, int x, int y, int u, int v, int w, int h) {
        super(tank, x, y, u, v, w, h);
        this.modules = modules;
    }

    @Override
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    private void refresh() {
        int count = 0;
        double temperaturePenalty = 0.0;
        double humidityMultiplier = 0.0;
        double precipitationMultiplier = 0.0;
        for (WaterCollectionModule module : this.modules) {
            WaterCollectionModule.State state = module.getState();
            if (!state.skyVisible()) continue;
            ++count;
            temperaturePenalty += state.temperaturePenalty();
            humidityMultiplier += state.humidityMultiplier();
            precipitationMultiplier += state.precipitationMultiplier();
        }
        if (count > 0) {
            humidityMultiplier /= (double)count;
            precipitationMultiplier /= (double)count;
        }
        this.tooltip = new ArrayList<Component>();
        Integer baseRate = (Integer)RailcraftConfig.SERVER.waterCollectionRate.get();
        this.tooltip.addAll(this.tank.getTooltip());
        this.tooltip.add((Component)Component.m_237119_());
        this.tooltip.add((Component)Component.m_237110_((String)Translations.Screen.WATER_TANK_SEE_SKY, (Object[])new Object[]{HumanReadableNumberFormatter.format(count)}).m_130940_(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.m_237110_((String)Translations.Screen.WATER_TANK_BASE_RATE, (Object[])new Object[]{HumanReadableNumberFormatter.format(baseRate * count)}).m_130940_(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.m_237110_((String)Translations.Screen.WATER_TANK_HUMIDITY, (Object[])new Object[]{HumanReadableNumberFormatter.format(humidityMultiplier)}).m_130940_(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.m_237110_((String)Translations.Screen.WATER_TANK_PRECIPITATION, (Object[])new Object[]{HumanReadableNumberFormatter.format(precipitationMultiplier)}).m_130940_(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.m_237110_((String)Translations.Screen.WATER_TANK_TEMP, (Object[])new Object[]{HumanReadableNumberFormatter.format(-temperaturePenalty)}).m_130940_(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.m_237110_((String)Translations.Screen.WATER_TANK_FINAL_RATE, (Object[])new Object[]{HumanReadableNumberFormatter.format((double)(baseRate * count) * humidityMultiplier * precipitationMultiplier - temperaturePenalty)}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public void writeToBuf(ServerPlayer player, FriendlyByteBuf out) {
        super.writeToBuf(player, out);
        this.refresh();
        out.m_236828_(this.tooltip, FriendlyByteBuf::m_130083_);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.tooltip = in.m_236845_(FriendlyByteBuf::m_130238_);
    }
}

