/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.npc;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class RailcraftVillagerTrades {
    public static void addTradeForTrackman(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        BiFunction<ItemStack, RandomSource, ItemStack> enchanter = (stack, rand) -> {
            EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)stack, (int)(15 + rand.m_188503_(16)), (boolean)true);
            return stack;
        };
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer(Items.f_42413_, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer((Item)RailcraftItems.COAL_COKE.get(), 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_41964_, 30, 34), new Offer(Items.f_42616_, 2, 3)));
        ((List)trades.get(2)).add(new TrackKitTrade());
        ((List)trades.get(2)).add(new TrackKitTrade());
        ((List)trades.get(3)).add(new TrackKitTrade());
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_CROWBAR.get()), new Offer(Items.f_42616_, 24, 52)).setEnchanter(enchanter).setUse(t -> 3));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.WHISTLE_TUNER.get()), new Offer(Items.f_42616_, 1, 2)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.SIGNAL_BLOCK_SURVEYOR.get()), new Offer(Items.f_42616_, 6, 8)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.SIGNAL_TUNER.get()), new Offer(Items.f_42616_, 6, 8)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.GOGGLES.get()), new Offer(Items.f_42616_, 4, 8)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.OVERALLS.get()), new Offer(Items.f_42616_, 19, 32)).setEnchanter(enchanter).setUse(t -> 3));
    }

    public static void addTradeForCartman(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer(Items.f_42413_, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer((Item)RailcraftItems.COAL_COKE.get(), 8, 12)));
        ((List)trades.get(2)).add(new CartTrade(false, 4, 7));
        ((List)trades.get(2)).add(new CartTrade(false, 4, 7));
        ((List)trades.get(3)).add(new CartTrade(false, 3, 5));
        ((List)trades.get(3)).add(new CartTrade(true, 30, 40));
        ((List)trades.get(3)).add(new CartTrade(true, 30, 40));
    }

    public static void addTradeForToolSmith(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer(Items.f_42413_, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer((Item)RailcraftItems.COAL_COKE.get(), 8, 12)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer(Items.f_42416_, 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_INGOT.get()), new Offer(Items.f_42616_, 1, 2), new Offer(Items.f_42416_)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_INGOT.get()), new Offer(Items.f_42616_, 3, 4)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer((Item)RailcraftItems.SLAG.get(), 1, 2), new Offer(Items.f_42616_, 2, 4)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_GEAR.get()), new Offer(Items.f_42616_, 9, 16)));
    }

    public static void addTradeForArmorer(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer(Items.f_42413_, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer((Item)RailcraftItems.COAL_COKE.get(), 4, 6), new Offer(Items.f_42616_)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer(Items.f_151052_, 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer((Item)RailcraftItems.TIN_INGOT.get(), 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer((Item)RailcraftItems.ZINC_INGOT.get(), 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.f_42616_), new Offer((Item)RailcraftItems.NICKEL_INGOT.get(), 7, 9)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRASS_INGOT.get()), new Offer(Items.f_42616_, 2, 3)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRONZE_INGOT.get()), new Offer(Items.f_42616_, 2, 3)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.INVAR_INGOT.get()), new Offer(Items.f_42616_, 2, 3)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRONZE_GEAR.get()), new Offer(Items.f_42616_, 6, 12)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRASS_GEAR.get()), new Offer(Items.f_42616_, 6, 12)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.INVAR_GEAR.get()), new Offer(Items.f_42616_, 6, 12)));
    }

    private static class GenericTrade
    implements VillagerTrades.ItemListing {
        private static final ToIntFunction<GenericTrade> USE_SETTER = t -> 7;
        private static final BiFunction<ItemStack, RandomSource, ItemStack> DEFAULT_ENCHANTER = (stack, rand) -> stack;
        private final Offer sale;
        private final Offer[] offers;
        private ToIntFunction<GenericTrade> maxUseSetter;
        private BiFunction<ItemStack, RandomSource, ItemStack> enchanter;

        public GenericTrade(Offer sale, Offer ... offers) {
            this.sale = sale;
            this.offers = offers;
            this.maxUseSetter = USE_SETTER;
            this.enchanter = DEFAULT_ENCHANTER;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            ItemStack sellStack = this.prepareStack(random, this.sale);
            ItemStack buyStack1 = this.prepareStack(random, this.offers[0]);
            ItemStack buyStack2 = ItemStack.f_41583_;
            if (this.offers.length >= 2) {
                buyStack2 = this.prepareStack(random, this.offers[1]);
            }
            return new MerchantOffer(buyStack1, buyStack2, this.enchanter.apply(sellStack, random), 12, 15, (float)this.maxUseSetter.applyAsInt(this));
        }

        GenericTrade setUse(ToIntFunction<GenericTrade> f) {
            this.maxUseSetter = f;
            return this;
        }

        GenericTrade setEnchanter(BiFunction<ItemStack, RandomSource, ItemStack> enchanter) {
            this.enchanter = enchanter;
            return this;
        }

        private ItemStack prepareStack(RandomSource random, Offer offer) {
            return new ItemStack((ItemLike)offer.item, this.stackSize(random, offer));
        }

        private int stackSize(RandomSource random, Offer offer) {
            return random.m_216332_(offer.min, offer.max);
        }
    }

    private static class Offer {
        private final Item item;
        private final int min;
        private final int max;

        private Offer(Item item, int min, int max) {
            this.item = item;
            this.min = min;
            this.max = max;
        }

        Offer(Item item, int amount) {
            this(item, amount, amount);
        }

        Offer(Item item) {
            this(item, 1);
        }
    }

    private static class TrackKitTrade
    implements VillagerTrades.ItemListing {
        private static final List<ItemStack> TRACK_KITS = RailcraftItems.entries().stream().map(RegistryObject::get).map(ItemStack::new).filter(kit -> kit.m_204117_(RailcraftTags.Items.TRACK_KIT)).collect(Collectors.toList());

        private TrackKitTrade() {
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            if (TRACK_KITS.isEmpty()) {
                return null;
            }
            ItemStack stack = TRACK_KITS.get(random.m_188503_(TRACK_KITS.size()));
            if (stack.m_41619_()) {
                return null;
            }
            int size = random.m_216332_(2, 6);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, size), stack, 12, 15, 7.0f);
        }
    }

    private static class CartTrade
    implements VillagerTrades.ItemListing {
        private static final List<EntityType<? extends AbstractMinecart>> CHEAP = new ArrayList<EntityType<? extends AbstractMinecart>>();
        private static final List<EntityType<? extends AbstractMinecart>> EXPENSIVE = new ArrayList<EntityType<? extends AbstractMinecart>>();
        private final List<EntityType<? extends AbstractMinecart>> current;
        private final int priceLow;
        private final int priceHigh;

        CartTrade(boolean expensive, int priceLow, int priceHigh) {
            this.current = expensive ? EXPENSIVE : CHEAP;
            this.priceHigh = priceHigh;
            this.priceLow = priceLow;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            if (this.current.isEmpty()) {
                return null;
            }
            ItemStack stack = ((AbstractMinecart)this.current.get(random.m_188503_(this.current.size())).m_20615_(trader.m_9236_())).m_142340_();
            int size = random.m_216332_(this.priceLow, this.priceHigh);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, size), stack, 12, 15, 7.0f);
        }

        static {
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.f_20469_);
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.f_20470_);
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.f_20473_);
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.f_20475_);
            CHEAP.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TANK_MINECART.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.WORLD_SPIKE.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_LAYER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_RELAYER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_REMOVER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_UNDERCUTTER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TUNNEL_BORE.get()));
        }
    }
}

