/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.poi;

import com.abdelaziz.canary.common.world.interests.PointOfInterestSetExtended;
import com.abdelaziz.canary.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PoiSection.class})
public class PoiSectionMixin
implements PointOfInterestSetExtended {
    @Mutable
    @Shadow
    @Final
    private Map<Holder<PoiType>, Set<PoiRecord>> f_27262_;

    private static <K, V> Iterable<? extends Map.Entry<K, V>> getPointsByTypeIterator(Map<K, V> map) {
        if (map instanceof Reference2ReferenceMap) {
            return Reference2ReferenceMaps.fastIterable((Reference2ReferenceMap)((Reference2ReferenceMap)map));
        }
        return map.entrySet();
    }

    @Inject(method={"<init>(Ljava/lang/Runnable;ZLjava/util/List;)V"}, at={@At(value="RETURN")})
    private void reinit(Runnable updateListener, boolean bl, List<PoiRecord> list, CallbackInfo ci) {
        this.f_27262_ = new Reference2ReferenceOpenHashMap(this.f_27262_);
    }

    @Override
    public void collectMatchingPoints(Predicate<Holder<PoiType>> type, PoiManager.Occupancy status, Consumer<PoiRecord> consumer) {
        if (type instanceof SinglePointOfInterestTypeFilter) {
            this.getWithSingleTypeFilter(((SinglePointOfInterestTypeFilter)type).getType(), status, consumer);
        } else {
            this.getWithDynamicTypeFilter(type, status, consumer);
        }
    }

    private void getWithDynamicTypeFilter(Predicate<Holder<PoiType>> type, PoiManager.Occupancy status, Consumer<PoiRecord> consumer) {
        for (Map.Entry<Holder<PoiType>, Set<PoiRecord>> entry : PoiSectionMixin.getPointsByTypeIterator(this.f_27262_)) {
            if (!type.test(entry.getKey()) || entry.getValue().isEmpty()) continue;
            for (PoiRecord poi : entry.getValue()) {
                if (!status.m_27221_().test(poi)) continue;
                consumer.accept(poi);
            }
        }
    }

    private void getWithSingleTypeFilter(Holder<PoiType> type, PoiManager.Occupancy status, Consumer<PoiRecord> consumer) {
        Set<PoiRecord> entries = this.f_27262_.get(type);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (PoiRecord poi : entries) {
            if (!status.m_27221_().test(poi)) continue;
            consumer.accept(poi);
        }
    }

    @Redirect(method={"add(Lnet/minecraft/world/entity/ai/village/poi/PoiRecord;)Z"}, at=@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;"))
    private <K, V> K computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        return (K)map.computeIfAbsent(key, o -> new ObjectOpenHashSet());
    }
}

