/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.registries.ForgeRegistries;

public class AdvancementDivineBlock
implements CriterionTrigger<Instance> {
    private final ResourceLocation RL;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public AdvancementDivineBlock(ResourceLocation parRL) {
        this.RL = parRL;
    }

    public AdvancementDivineBlock(String parString) {
        this.RL = new ResourceLocation(parString);
    }

    public ResourceLocation m_7295_() {
        return this.RL;
    }

    public void trigger(ServerPlayer player, Block block) {
        Listeners myCustomTrigger$listeners = this.listeners.get(player.m_8960_());
        if (myCustomTrigger$listeners != null) {
            myCustomTrigger$listeners.trigger(player, block);
        }
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Listeners myCustomTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (myCustomTrigger$listeners == null) {
            myCustomTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, myCustomTrigger$listeners);
        }
        myCustomTrigger$listeners.add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Listeners myCustomTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (myCustomTrigger$listeners != null) {
            myCustomTrigger$listeners.remove(listener);
            if (myCustomTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, DeserializationContext parser) {
        Block block = null;
        if (json.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.readNBT((JsonObject)json, (String)"block").m_7916_());
            if (!ForgeRegistries.BLOCKS.containsKey(resourcelocation)) {
                throw new JsonSyntaxException("Unknown block type '" + resourcelocation + "'");
            }
            block = (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
        }
        return new Instance(this.m_7295_(), block);
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ServerPlayer player, Block block) {
            ArrayList list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test(block)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener1 : list) {
                    listener1.m_13686_(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final Block block;

        public Instance(ResourceLocation parRL, @Nullable Block block) {
            super(parRL, ContextAwarePredicate.f_285567_);
            this.block = block;
        }

        public boolean test(Block block) {
            return this.block == null || block == this.block;
        }
    }
}

