/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.bosses;

import divinerpg.block_entities.ModUpdatableBlockEntity;
import divinerpg.entities.boss.EntityAyeraco;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AyeracoSpawnBlockEntity
extends ModUpdatableBlockEntity {
    public int spawnTick = 600;
    private BlockPos blueBeam;
    private BlockPos greenBeam;
    private BlockPos pinkBeam;
    private BlockPos purpleBeam;
    private BlockPos redBeam;
    private BlockPos yellowBeam;

    public AyeracoSpawnBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)BlockEntityRegistry.AYERACO_SPAWN.get(), p_155229_, p_155230_);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AyeracoSpawnBlockEntity block) {
        switch (block.spawnTick) {
            case 600: {
                block.blueBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, 15, 0);
                block.greenBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, 8, 12);
                block.pinkBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, -8, 12);
                block.purpleBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, -15, 0);
                block.redBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, -8, -12);
                block.yellowBeam = AyeracoSpawnBlockEntity.getBeamLocation(level, pos, 8, -12);
                level.m_7731_(block.blueBeam, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_blue"))).m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.BLUE);
                break;
            }
            case 500: {
                level.m_7731_(block.greenBeam, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_green"))).m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.GREEN);
                break;
            }
            case 400: {
                level.m_7731_(block.pinkBeam, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_pink"))).m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.LIGHT_PURPLE);
                break;
            }
            case 300: {
                level.m_7731_(block.purpleBeam, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_purple"))).m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.DARK_PURPLE);
                break;
            }
            case 200: {
                level.m_7731_(block.redBeam, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_red"))).m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.RED);
                break;
            }
            case 100: {
                level.m_7731_(block.yellowBeam, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_yellow"))).m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.YELLOW, "yellow");
                break;
            }
            case 0: {
                if (!level.f_46443_) {
                    byte i;
                    EntityAyeraco[] group = new EntityAyeraco[6];
                    for (i = 0; i < 6; i = (byte)(i + 1)) {
                        group[i] = ((EntityAyeraco)((EntityType)EntityRegistry.AYERACO.get()).m_262451_((ServerLevel)level, null, null, pos, MobSpawnType.MOB_SUMMONED, true, false)).setVariant(i);
                    }
                    group[0].setBeamPos(block.blueBeam).assignGroup(new EntityAyeraco[]{group[1], group[2], group[3], group[4], group[5]});
                    group[1].setBeamPos(block.greenBeam).assignGroup(new EntityAyeraco[]{group[0], group[2], group[3], group[4], group[5]});
                    group[2].setBeamPos(block.pinkBeam).assignGroup(new EntityAyeraco[]{group[1], group[0], group[3], group[4], group[5]});
                    group[3].setBeamPos(block.purpleBeam).assignGroup(new EntityAyeraco[]{group[1], group[2], group[0], group[4], group[5]});
                    group[4].setBeamPos(block.redBeam).assignGroup(new EntityAyeraco[]{group[1], group[2], group[3], group[0], group[5]});
                    group[5].setBeamPos(block.yellowBeam).assignGroup(new EntityAyeraco[]{group[1], group[2], group[3], group[4], group[0]});
                    for (i = 0; i < 6; i = (byte)(i + 1)) {
                        group[i].m_6027_(pos.m_123341_() + level.f_46441_.m_188503_(5) - 2, pos.m_123342_() + level.f_46441_.m_216339_(10, 20), pos.m_123343_() + level.f_46441_.m_188503_(5) - 2);
                        level.m_7967_((Entity)group[i]);
                        group[i].setVariant(i);
                    }
                }
                level.m_7731_(block.f_58858_, Blocks.f_50016_.m_49966_(), 3);
                AyeracoSpawnBlockEntity.logAyeracoSpawn(level, ChatFormatting.AQUA, "spawn");
            }
        }
        if (block.spawnTick > -1) {
            --block.spawnTick;
        }
    }

    private static BlockPos getBeamLocation(Level level, BlockPos pos, int x, int z) {
        BlockPos beamCoords = pos.m_7918_(x, 0, z);
        if (level.m_8055_(beamCoords) == Blocks.f_50016_.m_49966_()) {
            while (beamCoords.m_123342_() > 0 && level.m_8055_(beamCoords.m_7495_()) == Blocks.f_50016_.m_49966_()) {
                beamCoords = beamCoords.m_7495_();
            }
        } else {
            while (beamCoords.m_123342_() < 200 && level.m_8055_(beamCoords) != Blocks.f_50016_.m_49966_()) {
                beamCoords = beamCoords.m_7494_();
            }
        }
        return beamCoords;
    }

    public void m_142466_(CompoundTag tag) {
        this.spawnTick = tag.m_128451_("spawnTick");
        this.blueBeam = BlockPos.m_122022_((long)tag.m_128454_("blueBeam"));
        this.greenBeam = BlockPos.m_122022_((long)tag.m_128454_("greenBeam"));
        this.pinkBeam = BlockPos.m_122022_((long)tag.m_128454_("pinkBeam"));
        this.purpleBeam = BlockPos.m_122022_((long)tag.m_128454_("purpleBeam"));
        this.redBeam = BlockPos.m_122022_((long)tag.m_128454_("redBeam"));
        this.yellowBeam = BlockPos.m_122022_((long)tag.m_128454_("yellowBeam"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("spawnTick", this.spawnTick);
        if (this.blueBeam != null) {
            tag.m_128356_("blueBeam", this.blueBeam.m_121878_());
        }
        if (this.greenBeam != null) {
            tag.m_128356_("greenBeam", this.greenBeam.m_121878_());
        }
        if (this.pinkBeam != null) {
            tag.m_128356_("greenBeam", this.pinkBeam.m_121878_());
        }
        if (this.purpleBeam != null) {
            tag.m_128356_("purpleBeam", this.purpleBeam.m_121878_());
        }
        if (this.redBeam != null) {
            tag.m_128356_("redBeam", this.redBeam.m_121878_());
        }
        if (this.yellowBeam != null) {
            tag.m_128356_("yellowBeam", this.yellowBeam.m_121878_());
        }
    }

    private static void logAyeracoSpawn(Level level, ChatFormatting formatting) {
        AyeracoSpawnBlockEntity.logAyeracoSpawn(level, formatting, null);
    }

    private static void logAyeracoSpawn(Level level, ChatFormatting formatting, String name) {
        if (level.m_7654_() != null) {
            if (name == null) {
                name = formatting.name().toLowerCase();
            }
            String langKey = "ayeraco." + name;
            level.m_7654_().m_6846_().m_11314_().forEach(x -> {
                Component text = LocalizeUtils.clientMessage(formatting, langKey, new Object[0]);
                x.m_5661_(text, true);
            });
        }
    }
}

