/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.furnace;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class ModFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public final String containerName;
    public final double speed;
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    return ModFurnaceBlockEntity.this.litTime;
                }
                case 1: {
                    return ModFurnaceBlockEntity.this.litDuration;
                }
                case 2: {
                    return ModFurnaceBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return ModFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    ModFurnaceBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    ModFurnaceBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    ModFurnaceBlockEntity.this.cookingProgress = p_58434_;
                    break;
                }
                case 3: {
                    ModFurnaceBlockEntity.this.cookingTotalTime = p_58434_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public ModFurnaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, String containerName, double speed) {
        super(type, pos, state);
        this.containerName = containerName;
        this.speed = speed;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)this.containerName);
    }

    protected int getBurnDuration(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return (int)((double)ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) / this.speed);
    }

    public static int getTotalCookTime(Level level, ModFurnaceBlockEntity tile) {
        return (int)((double)tile.quickCheck.m_213657_((Container)tile, level).map(AbstractCookingRecipe::m_43753_).orElse(200).intValue() / tile.speed);
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag p_155025_) {
        super.m_142466_(p_155025_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_155025_, this.items);
        this.litTime = p_155025_.m_128451_("BurnTime");
        this.cookingProgress = p_155025_.m_128451_("CookTime");
        this.cookingTotalTime = p_155025_.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = p_155025_.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag p_187452_) {
        super.m_183515_(p_187452_);
        p_187452_.m_128405_("BurnTime", this.litTime);
        p_187452_.m_128405_("CookTime", this.cookingProgress);
        p_187452_.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)p_187452_, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        p_187452_.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level p_155014_, BlockPos p_155015_, BlockState p_155016_, ModFurnaceBlockEntity p_155017_) {
        boolean flag3;
        boolean flag = p_155017_.isLit();
        boolean flag1 = false;
        if (p_155017_.isLit()) {
            --p_155017_.litTime;
        }
        ItemStack itemstack = (ItemStack)p_155017_.items.get(1);
        boolean flag2 = !((ItemStack)p_155017_.items.get(0)).m_41619_();
        boolean bl = flag3 = !itemstack.m_41619_();
        if (p_155017_.isLit() || flag3 && flag2) {
            Recipe recipe = flag2 ? (Recipe)p_155017_.quickCheck.m_213657_((Container)p_155017_, p_155014_).orElse(null) : null;
            int i = p_155017_.m_6893_();
            if (!p_155017_.isLit() && p_155017_.canBurn(recipe, p_155017_.items, i)) {
                p_155017_.litDuration = p_155017_.litTime = p_155017_.getBurnDuration(itemstack);
                if (p_155017_.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        p_155017_.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            p_155017_.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (p_155017_.isLit() && p_155017_.canBurn(recipe, p_155017_.items, i)) {
                ++p_155017_.cookingProgress;
                if (p_155017_.cookingProgress == p_155017_.cookingTotalTime) {
                    p_155017_.cookingProgress = 0;
                    p_155017_.cookingTotalTime = ModFurnaceBlockEntity.getTotalCookTime(p_155014_, p_155017_);
                    if (p_155017_.burn(recipe, p_155017_.items, i)) {
                        p_155017_.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                p_155017_.cookingProgress = 0;
            }
        } else if (!p_155017_.isLit() && p_155017_.cookingProgress > 0) {
            p_155017_.cookingProgress = Mth.m_14045_((int)(p_155017_.cookingProgress - 2), (int)0, (int)p_155017_.cookingTotalTime);
        }
        if (flag != p_155017_.isLit()) {
            flag1 = true;
            p_155016_ = (BlockState)p_155016_.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(p_155017_.isLit()));
            p_155014_.m_7731_(p_155015_, p_155016_, 3);
        }
        if (flag1) {
            ModFurnaceBlockEntity.m_155232_((Level)p_155014_, (BlockPos)p_155015_, (BlockState)p_155016_);
        }
    }

    private boolean canBurn(@Nullable Recipe<?> p_155006_, NonNullList<ItemStack> p_155007_, int p_155008_) {
        if (!((ItemStack)p_155007_.get(0)).m_41619_() && p_155006_ != null) {
            ItemStack itemstack = p_155006_.m_5874_((Container)this, this.f_58857_.m_9598_());
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)p_155007_.get(2);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= p_155008_ && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean burn(@Nullable Recipe<?> p_155027_, NonNullList<ItemStack> p_155028_, int p_155029_) {
        if (p_155027_ != null && this.canBurn(p_155027_, p_155028_, p_155029_)) {
            ItemStack itemstack = (ItemStack)p_155028_.get(0);
            ItemStack itemstack1 = p_155027_.m_5874_((Container)this, this.f_58857_.m_9598_());
            ItemStack itemstack2 = (ItemStack)p_155028_.get(2);
            if (itemstack2.m_41619_()) {
                p_155028_.set(2, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (itemstack.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)p_155028_.get(1)).m_41619_() && ((ItemStack)p_155028_.get(1)).m_150930_(Items.f_42446_)) {
                p_155028_.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack p_58400_) {
        return ForgeHooks.getBurnTime((ItemStack)p_58400_, null) > 0;
    }

    public int[] m_7071_(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return p_58363_ == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int p_58336_, ItemStack p_58337_, @Nullable Direction p_58338_) {
        return this.m_7013_(p_58336_, p_58337_);
    }

    public boolean m_7157_(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        if (p_58394_ == Direction.DOWN && p_58392_ == 1) {
            return p_58393_.m_150930_(Items.f_42447_) || p_58393_.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_58328_) {
        return (ItemStack)this.items.get(p_58328_);
    }

    public ItemStack m_7407_(int p_58330_, int p_58331_) {
        return ContainerHelper.m_18969_(this.items, (int)p_58330_, (int)p_58331_);
    }

    public ItemStack m_8016_(int p_58387_) {
        return ContainerHelper.m_18966_(this.items, (int)p_58387_);
    }

    public void m_6836_(int p_58333_, ItemStack p_58334_) {
        ItemStack itemstack = (ItemStack)this.items.get(p_58333_);
        boolean flag = !p_58334_.m_41619_() && ItemStack.m_41656_((ItemStack)p_58334_, (ItemStack)itemstack) && ItemStack.m_41656_((ItemStack)p_58334_, (ItemStack)itemstack);
        this.items.set(p_58333_, (Object)p_58334_);
        if (p_58334_.m_41613_() > this.m_6893_()) {
            p_58334_.m_41764_(this.m_6893_());
        }
        if (p_58333_ == 0 && !flag) {
            this.cookingTotalTime = ModFurnaceBlockEntity.getTotalCookTime(this.f_58857_, this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player p_58340_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_58340_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int p_58389_, ItemStack p_58390_) {
        if (p_58389_ == 2) {
            return false;
        }
        if (p_58389_ != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return ForgeHooks.getBurnTime((ItemStack)p_58390_, (RecipeType)RecipeType.f_44108_) > 0 || p_58390_.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> p_58345_) {
        if (p_58345_ != null) {
            ResourceLocation resourcelocation = p_58345_.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player p_281647_, List<ItemStack> p_282578_) {
        super.m_58395_(p_281647_, p_282578_);
    }

    public boolean m_40135_(Level level, ServerPlayer player, Recipe<?> recipe) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
        return super.m_40135_(level, player, recipe);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> recipesToAward = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(recipesToAward);
        for (Recipe<?> recipe : recipesToAward) {
            if (recipe == null) continue;
            player.m_280300_(recipe, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                ModFurnaceBlockEntity.createExperience(level, position, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int entry, float amount) {
        int xpAmount = Mth.m_14143_((float)((float)entry * amount));
        float xpFraction = Mth.m_14187_((float)((float)entry * amount));
        if (xpFraction != 0.0f && Math.random() < (double)xpFraction) {
            ++xpAmount;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)xpAmount);
    }

    public void m_5809_(StackedContents p_58342_) {
        for (ItemStack itemstack : this.items) {
            p_58342_.m_36491_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

