/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.blocks.arcana.BlockArcanaPortalFrame;
import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.LevelRegistry;
import divinerpg.util.teleport.ArcanaTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;

public class BlockArcanaPortal
extends BlockMod {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BlockArcanaPortal() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50257_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_() && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()))), (VoxelShape)state.m_60808_((BlockGetter)world, pos), (BooleanOp)BooleanOp.f_82689_)) {
                if (entity.m_20092_()) {
                    entity.m_20091_();
                } else {
                    ServerLevel serverworld = server.m_7654_().m_129880_(world.m_46472_() == LevelRegistry.ARCANA ? Level.f_46428_ : LevelRegistry.ARCANA);
                    if (serverworld == null) {
                        return;
                    }
                    ResourceKey destination = LevelRegistry.ARCANA;
                    if (destination == world.m_46472_()) {
                        destination = Level.f_46428_;
                    }
                    BlockArcanaPortal.transferEntity(entity, world.m_7654_().m_129880_(destination));
                }
            }
        }
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    public static void transferEntity(Entity e, ServerLevel modDimension) {
        if (e == null || modDimension == null) {
            return;
        }
        e.changeDimension(modDimension, (ITeleporter)new ArcanaTeleporter(modDimension, modDimension.m_215082_().m_230359_(new ResourceLocation("divinerpg", "arcana/portal"))));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos2, boolean unknown) {
        BlockPattern.BlockPatternMatch frame = BlockArcanaPortalFrame.getOrCreatePortalShape().m_61184_((LevelReader)world, pos);
        if (frame == null && world.m_46472_() != LevelRegistry.ARCANA) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }
}

