/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import divinerpg.config.CommonConfig;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.PointOfInterestRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.teleport.DivineTeleporter;
import divinerpg.util.teleport.VetheaTeleporter;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class BlockModPortal
extends BlockMod {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static Block frame;

    public BlockModPortal(Block frame) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 0.0f).m_60910_().m_60953_(state -> 11).m_60918_(SoundType.f_56744_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(worldIn, currentPos, direction$axis1, this, frame).validatePortal() ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_() && !entity.m_9236_().f_46443_ && world != null && world.m_46472_() != null) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            }
            if (!entity.m_20092_() && entity instanceof LivingEntity) {
                entity.m_9236_().m_46473_().m_6180_(world.m_46472_().m_135782_().m_135815_());
                if (this == BlockRegistry.edenPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.EDEN ? Level.f_46428_ : LevelRegistry.EDEN;
                    if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new DivineTeleporter(world.m_7654_().m_129880_(key), (Block)BlockRegistry.edenPortal.get(), (Block)BlockRegistry.divineRock.get(), true, (ResourceKey<PoiType>)PointOfInterestRegistry.EDEN_PORTAL.getKey()));
                    }
                } else if (this == BlockRegistry.wildwoodPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.WILDWOOD ? Level.f_46428_ : LevelRegistry.WILDWOOD;
                    if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new DivineTeleporter(world.m_7654_().m_129880_(key), (Block)BlockRegistry.wildwoodPortal.get(), (Block)BlockRegistry.edenBlock.get(), true, (ResourceKey<PoiType>)PointOfInterestRegistry.WILDWOOD_PORTAL.getKey()));
                    }
                } else if (this == BlockRegistry.apalachiaPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.APALACHIA ? Level.f_46428_ : LevelRegistry.APALACHIA;
                    if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new DivineTeleporter(world.m_7654_().m_129880_(key), (Block)BlockRegistry.apalachiaPortal.get(), (Block)BlockRegistry.wildwoodBlock.get(), true, (ResourceKey<PoiType>)PointOfInterestRegistry.APALACHIA_PORTAL.getKey()));
                    }
                } else if (this == BlockRegistry.skythernPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.SKYTHERN ? Level.f_46428_ : LevelRegistry.SKYTHERN;
                    if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new DivineTeleporter(world.m_7654_().m_129880_(key), (Block)BlockRegistry.skythernPortal.get(), (Block)BlockRegistry.apalachiaBlock.get(), true, (ResourceKey<PoiType>)PointOfInterestRegistry.SKYTHERN_PORTAL.getKey()));
                    }
                } else if (this == BlockRegistry.mortumPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.MORTUM ? Level.f_46428_ : LevelRegistry.MORTUM;
                    if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new DivineTeleporter(world.m_7654_().m_129880_(key), (Block)BlockRegistry.mortumPortal.get(), (Block)BlockRegistry.skythernBlock.get(), true, (ResourceKey<PoiType>)PointOfInterestRegistry.MORTUM_PORTAL.getKey()));
                    }
                } else if (this == BlockRegistry.iceikaPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.ICEIKA ? Level.f_46428_ : LevelRegistry.ICEIKA;
                    if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new DivineTeleporter(world.m_7654_().m_129880_(key), (Block)BlockRegistry.iceikaPortal.get(), Blocks.f_50127_, true, (ResourceKey<PoiType>)PointOfInterestRegistry.ICEIKA_PORTAL.getKey()));
                    }
                } else if (this == BlockRegistry.vetheaPortal.get()) {
                    ResourceKey<Level> key;
                    ResourceKey<Level> resourceKey = key = world.m_46472_() == LevelRegistry.VETHEA ? Level.f_46428_ : LevelRegistry.VETHEA;
                    if (((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                        if (world.m_7654_().m_129880_(key) != null && entity instanceof Player) {
                            Player player = (Player)entity;
                            if (player.f_36093_.m_7983_()) {
                                entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new VetheaTeleporter(true));
                            } else {
                                Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "vethea_portal.inventory_full", player.m_5446_());
                                player.m_5661_(message, true);
                            }
                        }
                    } else if (world.m_7654_().m_129880_(key) != null) {
                        entity.changeDimension(world.m_7654_().m_129880_(key), (ITeleporter)new VetheaTeleporter(true));
                    }
                }
                entity.m_9236_().m_46473_().m_7238_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + rand.m_188500_();
            double y = (double)pos.m_123342_() + rand.m_188500_();
            double z = (double)pos.m_123343_() + rand.m_188500_();
            double xSpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            double ySpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            double zSpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            int j = rand.m_188503_(2) * 2 - 1;
            if (!worldIn.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !worldIn.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                xSpeed = rand.m_188501_() * 2.0f * (float)j;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                zSpeed = rand.m_188501_() * 2.0f * (float)j;
            }
            if (this == BlockRegistry.edenPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.EDEN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == BlockRegistry.wildwoodPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.WILDWOOD_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == BlockRegistry.apalachiaPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.APALACHIA_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == BlockRegistry.skythernPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.SKYTHERN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == BlockRegistry.mortumPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.MORTUM_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == BlockRegistry.iceikaPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.FROST.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == BlockRegistry.vetheaPortal.get()) {
                worldIn.m_7106_((ParticleOptions)ParticleRegistry.MORTUM_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public boolean makePortal(LevelAccessor worldIn, BlockPos pos) {
        Size portal = this.isPortal(worldIn, pos);
        if (worldIn.m_8055_(pos.m_7495_()) == Blocks.f_50752_.m_49966_()) {
            pos = pos.m_6625_(10);
        }
        if (portal != null && !BlockModPortal.onTrySpawnPortal(worldIn, pos, portal)) {
            portal.createPortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(LevelAccessor world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.m_8055_(pos), size));
    }

    @Nullable
    public Size isPortal(LevelAccessor worldIn, BlockPos pos) {
        Size portalX = new Size(worldIn, pos, Direction.Axis.X, this, worldIn.m_8055_(pos.m_7495_()).m_60734_());
        if (portalX.isValid() && portalX.portalBlockCount == 0) {
            return portalX;
        }
        Size portalZ = new Size(worldIn, pos, Direction.Axis.Z, this, worldIn.m_8055_(pos.m_7495_()).m_60734_());
        return portalZ.isValid() && portalZ.portalBlockCount == 0 ? portalZ : null;
    }

    public static class Size {
        private final LevelAccessor world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private Block portal;
        private Block frame;

        public Size(LevelAccessor worldIn, BlockPos pos, Direction.Axis axisIn, Block portal, Block frame) {
            this.world = worldIn;
            this.axis = axisIn;
            this.portal = portal;
            this.frame = frame;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.m_123342_() > blockpos.m_123342_() - 21 && pos.m_123342_() > 0 && this.canConnect(worldIn.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.m_5484_(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canConnect(this.world.m_8055_(blockpos = pos.m_5484_(directionIn, i))) && this.world.m_8055_(blockpos.m_7495_()).m_60734_().equals(this.world.m_8055_(pos.m_7495_()).m_60734_()); ++i) {
            }
            BlockPos framePos = pos.m_5484_(directionIn, i);
            return this.world.m_8055_(framePos).m_60734_().equals(this.world.m_8055_(pos.m_7495_()).m_60734_()) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i).m_6630_(this.height);
                    BlockState blockstate = this.world.m_8055_(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.m_60734_();
                    if (block == this.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.world.m_8055_(framePos = blockpos.m_121945_(this.leftDir)).m_60734_().equals(this.frame) || this.world.m_8055_(framePos).m_60734_() != this.frame : i == this.width - 1 && (!this.world.m_8055_(framePos = blockpos.m_121945_(this.rightDir)).m_60734_().equals(this.frame) || this.world.m_8055_(framePos).m_60734_() != this.frame)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.m_5484_(this.rightDir, j).m_6630_(this.height);
                if (!this.world.m_8055_(framePos).m_60734_().equals(this.frame)) {
                    this.height = 0;
                    break;
                }
                if (this.world.m_8055_(framePos).m_60734_() == this.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.m_60734_();
            return pos.m_60795_() || block == this.portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)this.portal.m_49966_().m_61124_(AXIS, (Comparable)this.axis);
            BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(pos -> this.world.m_7731_(pos, blockstate, 18));
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final Size size;

        public PortalSpawnEvent(LevelAccessor world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public Size getPortalSize() {
            return this.size;
        }
    }
}

