/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.blocks.vethea.BlockVetheaAltar;
import divinerpg.entities.boss.EntityKaros;
import divinerpg.registries.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockKarosAltar
extends BlockVetheaAltar {
    public BlockKarosAltar(MapColor color) {
        super(color);
    }

    @Override
    protected Item acceptedItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("divinerpg", "dream_flint"));
    }

    protected BlockPos findSafeBossSpawnPos(Level worldIn, BlockPos pos, int radius) {
        RandomSource rand = worldIn.f_46441_;
        for (int i = 0; i < 10; ++i) {
            int x = pos.m_123341_() + rand.m_188503_(radius * 2) - radius;
            int y = pos.m_123342_();
            int z = pos.m_123343_() + rand.m_188503_(radius * 2) - radius;
            BlockPos spawnPos = new BlockPos(x, y, z);
            AABB bossHitbox = this.getBoss(worldIn).m_20191_().m_82386_((double)x, (double)y, (double)z);
            if (!worldIn.m_45756_((Entity)this.getBoss(worldIn), bossHitbox)) continue;
            return spawnPos;
        }
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldItemStack = player.m_21120_(hand);
        BlockPos bossSpawnPos = this.findSafeBossSpawnPos(world, pos, 10);
        if (bossSpawnPos != null && heldItemStack != null && heldItemStack.m_41720_() == this.acceptedItem()) {
            if (!player.m_7500_()) {
                heldItemStack.m_41774_(1);
            }
            this.spawnBoss(world, bossSpawnPos.m_7494_());
            return InteractionResult.SUCCESS;
        }
        this.onFailure();
        return InteractionResult.PASS;
    }

    @Override
    protected LivingEntity getBoss(Level world) {
        return new EntityKaros((EntityType<? extends Monster>)((EntityType)EntityRegistry.KAROS.get()), world);
    }

    @Override
    protected void onFailure() {
    }
}

