/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.entities.projectile.EntityDivineArrow;
import divinerpg.enums.ArrowType;
import divinerpg.registries.EntityRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockKarosDispenser
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    private static final Map<Item, DispenseItemBehavior> DISPENSER_REGISTRY = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), p_212564_0_ -> p_212564_0_.defaultReturnValue((Object)new DefaultDispenseItemBehavior()));

    public static void registerBehavior(ItemLike provider, DispenseItemBehavior behavior) {
        DISPENSER_REGISTRY.put(provider.m_5456_(), behavior);
    }

    public BlockKarosDispenser() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60913_(-1.0f, 3600000.0f).m_280658_(NoteBlockInstrument.BASEDRUM));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level p_225533_2_, BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_2_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = p_225533_2_.m_7702_(p_225533_3_);
        if (blockEntity instanceof DispenserBlockEntity) {
            p_225533_4_.m_5893_((MenuProvider)((DispenserBlockEntity)blockEntity));
            if (blockEntity instanceof DropperBlockEntity) {
                p_225533_4_.m_36220_(Stats.f_12956_);
            } else {
                p_225533_4_.m_36220_(Stats.f_12958_);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void dispenseFrom(ServerLevel world, BlockPos pos) {
        double var5 = pos.m_123341_();
        double var7 = pos.m_123342_();
        double var9 = pos.m_123343_();
        BlockSourceImpl proxyblocksource = new BlockSourceImpl(world, pos);
        Direction direction = (Direction)proxyblocksource.m_6414_().m_61143_((Property)FACING);
        EntityDivineArrow var11 = new EntityDivineArrow((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ARROW_SHOT.get()), (Level)world, ArrowType.KAROS_ARROW, var5 + 0.5 + (double)direction.m_122429_(), var7 + 0.5, var9 + 0.5 + (double)direction.m_122431_());
        var11.damageMax = 12.0;
        var11.damageMin = 12.0;
        double var12 = world.f_46441_.m_188500_() * 0.1 + 0.9;
        var11.m_20334_((double)direction.m_122429_() * var12, 0.0, (double)direction.m_122431_() * var12);
        var11.m_20334_(var11.m_20184_().f_82479_, var11.m_20184_().f_82480_ + 0.0, var11.m_20184_().f_82481_);
        world.m_7967_((Entity)var11);
    }

    protected DispenseItemBehavior getDispenseMethod(ItemStack stack) {
        return DISPENSER_REGISTRY.get(stack.m_41720_());
    }

    public void m_6861_(BlockState p_220069_1_, Level p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        boolean flag = p_220069_2_.m_276867_(p_220069_3_) || p_220069_2_.m_276867_(p_220069_3_.m_7494_());
        boolean flag1 = (Boolean)p_220069_1_.m_61143_((Property)TRIGGERED);
        if (flag && !flag1) {
            p_220069_2_.m_183326_().m_183588_(p_220069_3_, (Object)this);
            p_220069_2_.m_7731_(p_220069_3_, (BlockState)p_220069_1_.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!flag && flag1) {
            p_220069_2_.m_7731_(p_220069_3_, (BlockState)p_220069_1_.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void tick(BlockState p_225534_1_, ServerLevel p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        this.dispenseFrom(p_225534_2_, p_225534_3_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new DispenserBlockEntity(p_153215_, p_153216_);
    }

    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_196258_1_.m_7820_().m_122424_());
    }

    public void m_6402_(Level p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        BlockEntity blockEntity;
        if (p_180633_5_.m_41788_() && (blockEntity = p_180633_1_.m_7702_(p_180633_2_)) instanceof DispenserBlockEntity) {
            ((DispenserBlockEntity)blockEntity).m_58638_(p_180633_5_.m_41786_());
        }
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity blockEntity = p_196243_2_.m_7702_(p_196243_3_);
            if (blockEntity instanceof DispenserBlockEntity) {
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((DispenserBlockEntity)blockEntity));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public static Position getDispensePosition(BlockSource p_149939_0_) {
        Direction direction = (Direction)p_149939_0_.m_6414_().m_61143_((Property)FACING);
        double d0 = p_149939_0_.m_7096_() + 0.7 * (double)direction.m_122429_();
        double d1 = p_149939_0_.m_7098_() + 0.7 * (double)direction.m_122430_();
        double d2 = p_149939_0_.m_7094_() + 0.7 * (double)direction.m_122431_();
        return new PositionImpl(d0, d1, d2);
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState p_180641_1_, Level p_180641_2_, BlockPos p_180641_3_) {
        return AbstractContainerMenu.m_38918_((BlockEntity)p_180641_2_.m_7702_(p_180641_3_));
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.m_60717_(p_185471_2_.m_54846_((Direction)p_185471_1_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{FACING, TRIGGERED});
    }
}

