/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.entities.base.FactionEntity;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;

public class Reputation {
    ArrayList<FactionEntity.Faction> factions = new ArrayList();
    ArrayList<Integer> reputation = new ArrayList();

    public void transferTo(Reputation target) {
        target.factions = this.factions;
        target.reputation = this.reputation;
    }

    public void resetReputation(FactionEntity.Faction faction) {
        int i = this.factions.indexOf(faction);
        if (i > -1) {
            this.reputation.set(i, faction.startingReputation);
        }
    }

    public void setReputation(FactionEntity.Faction faction, int reputation) {
        int i = this.factions.indexOf(faction);
        if (i > -1) {
            this.reputation.set(i, reputation);
        } else {
            this.factions.add(faction);
            this.reputation.add(reputation);
        }
    }

    public void modifyReputation(FactionEntity.Faction faction, int reputation) {
        int i = this.factions.indexOf(faction);
        if (i > -1) {
            this.reputation.set(i, this.reputation.get(i) + reputation);
        } else {
            this.factions.add(faction);
            this.reputation.add(faction.startingReputation + reputation);
        }
    }

    public int getReputation(FactionEntity.Faction faction) {
        int i = this.factions.indexOf(faction);
        if (i > -1) {
            return this.reputation.get(i);
        }
        return faction.startingReputation;
    }

    public CompoundTag saveTo(CompoundTag tag) {
        for (int i = 0; i < this.factions.size(); ++i) {
            tag.m_128405_(this.factions.get((int)i).reputationIdentifier, this.reputation.get(i).intValue());
        }
        return tag;
    }

    public void loadFrom(CompoundTag tag) {
        if (tag.m_128441_(FactionEntity.Faction.GROGLIN.reputationIdentifier)) {
            this.setReputation(FactionEntity.Faction.GROGLIN, tag.m_128451_(FactionEntity.Faction.GROGLIN.reputationIdentifier));
        }
        if (tag.m_128441_(FactionEntity.Faction.GRUZZORLUG.reputationIdentifier)) {
            this.setReputation(FactionEntity.Faction.GRUZZORLUG, tag.m_128451_(FactionEntity.Faction.GRUZZORLUG.reputationIdentifier));
        }
        if (tag.m_128441_(FactionEntity.Faction.ICEIKA_MERCHANT.reputationIdentifier)) {
            this.setReputation(FactionEntity.Faction.ICEIKA_MERCHANT, tag.m_128451_(FactionEntity.Faction.ICEIKA_MERCHANT.reputationIdentifier));
        }
    }
}

