/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.capability.SoulTrapCount;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulTrapCountProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<SoulTrapCount> SOUL_TRAP_COUNT = CapabilityManager.get((CapabilityToken)new CapabilityToken<SoulTrapCount>(){});
    private SoulTrapCount counter = null;
    private final LazyOptional<SoulTrapCount> opt = LazyOptional.of(this::createCounter);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return SOUL_TRAP_COUNT.orEmpty(cap, this.opt);
    }

    private SoulTrapCount createCounter() {
        if (this.counter == null) {
            this.counter = new SoulTrapCount();
        }
        return this.counter;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.counter != null) {
            tag.m_128405_("count", this.counter.count);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("count")) {
            int count = nbt.m_128451_("count");
            if (this.counter == null) {
                this.counter = new SoulTrapCount(count);
            } else {
                this.counter.count = count;
            }
        }
    }
}

