/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.menu;

import divinerpg.blocks.vanilla.BlockAltarOfCorruption;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.MenuTypeRegistry;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class AltarOfCorruptionMenu
extends AbstractContainerMenu {
    private final Container enchantSlots = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            AltarOfCorruptionMenu.this.m_6199_((Container)this);
        }
    };
    private final ContainerLevelAccess access;
    private final RandomSource random = RandomSource.m_216327_();
    private final DataSlot enchantmentSeed = DataSlot.m_39401_();
    public final int[] costs = new int[3];
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] levelClue = new int[]{-1, -1, -1};

    public AltarOfCorruptionMenu(int p_39454_, Inventory p_39455_) {
        this(p_39454_, p_39455_, ContainerLevelAccess.f_39287_);
    }

    public AltarOfCorruptionMenu(int p_39457_, Inventory p_39458_, ContainerLevelAccess p_39459_) {
        super((MenuType)MenuTypeRegistry.ALTAR_OF_CORRUPTION.get(), p_39457_);
        this.access = p_39459_;
        this.m_38897_(new Slot(this.enchantSlots, 0, 15, 47){

            public boolean m_5857_(ItemStack p_39508_) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.enchantSlots, 1, 35, 47){

            public boolean m_5857_(ItemStack p_39517_) {
                return p_39517_.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)p_39458_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)p_39458_, k, 8 + k * 18, 142));
        }
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)2));
        this.m_38895_(this.enchantmentSeed).m_6422_(p_39458_.f_35978_.m_36322_());
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.enchantClue, (int)2));
        this.m_38895_(DataSlot.m_39406_((int[])this.levelClue, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.levelClue, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.levelClue, (int)2));
    }

    public AltarOfCorruptionMenu(int i, Inventory inventory, FriendlyByteBuf buf) {
        this(i, inventory, ContainerLevelAccess.f_39287_);
    }

    public void m_6199_(Container p_39461_) {
        if (p_39461_ == this.enchantSlots) {
            ItemStack itemstack = p_39461_.m_8020_(0);
            if (!itemstack.m_41619_() && itemstack.m_41792_()) {
                this.access.m_39292_((p_39485_, p_39486_) -> {
                    float j = 30.0f;
                    for (BlockPos blockpos : BlockAltarOfCorruption.BOOKSHELF_OFFSETS) {
                        if (!BlockAltarOfCorruption.isValidBookShelf(p_39485_, p_39486_, blockpos)) continue;
                        j += p_39485_.m_8055_(p_39486_.m_121955_((Vec3i)blockpos)).getEnchantPowerBonus((LevelReader)p_39485_, p_39486_.m_121955_((Vec3i)blockpos));
                    }
                    this.random.m_188584_((long)this.enchantmentSeed.m_6501_());
                    for (int k = 0; k < 3; ++k) {
                        this.costs[k] = EnchantmentHelper.m_220287_((RandomSource)this.random, (int)k, (int)((int)j), (ItemStack)itemstack);
                        this.enchantClue[k] = -1;
                        this.levelClue[k] = -1;
                        if (this.costs[k] < k + 1) {
                            this.costs[k] = 0;
                        }
                        this.costs[k] = ForgeEventFactory.onEnchantmentLevelSet((Level)p_39485_, (BlockPos)p_39486_, (int)k, (int)((int)j), (ItemStack)itemstack, (int)this.costs[k]);
                    }
                    for (int l = 0; l < 3; ++l) {
                        List<EnchantmentInstance> list;
                        if (this.costs[l] <= 0 || (list = this.getEnchantmentList(itemstack, l, this.costs[l])) == null || list.isEmpty()) continue;
                        EnchantmentInstance enchantmentinstance = list.get(this.random.m_188503_(list.size()));
                        this.enchantClue[l] = BuiltInRegistries.f_256876_.m_7447_((Object)enchantmentinstance.f_44947_);
                        this.levelClue[l] = enchantmentinstance.f_44948_;
                    }
                    this.m_38946_();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.costs[i] = 0;
                    this.enchantClue[i] = -1;
                    this.levelClue[i] = -1;
                }
            }
        }
    }

    public boolean m_6366_(Player p_39465_, int p_39466_) {
        if (p_39466_ >= 0 && p_39466_ < this.costs.length) {
            ItemStack itemstack = this.enchantSlots.m_8020_(0);
            ItemStack itemstack1 = this.enchantSlots.m_8020_(1);
            int i = p_39466_ + 1;
            if ((itemstack1.m_41619_() || itemstack1.m_41613_() < i) && !p_39465_.m_150110_().f_35937_) {
                return false;
            }
            if (this.costs[p_39466_] <= 0 || itemstack.m_41619_() || (p_39465_.f_36078_ < i || p_39465_.f_36078_ < this.costs[p_39466_]) && !p_39465_.m_150110_().f_35937_) {
                return false;
            }
            this.access.m_39292_((p_39481_, p_39482_) -> {
                ItemStack itemstack2 = itemstack;
                List<EnchantmentInstance> list = this.getEnchantmentList(itemstack, p_39466_, this.costs[p_39466_]);
                if (!list.isEmpty()) {
                    p_39465_.m_7408_(itemstack, i);
                    boolean flag = itemstack.m_150930_(Items.f_42517_);
                    if (flag) {
                        itemstack2 = new ItemStack((ItemLike)Items.f_42690_);
                        CompoundTag compoundtag = itemstack.m_41783_();
                        if (compoundtag != null) {
                            itemstack2.m_41751_(compoundtag.m_6426_());
                        }
                        this.enchantSlots.m_6836_(0, itemstack2);
                    }
                    for (int j = 0; j < list.size(); ++j) {
                        EnchantmentInstance enchantmentinstance = list.get(j);
                        if (flag) {
                            EnchantedBookItem.m_41153_((ItemStack)itemstack2, (EnchantmentInstance)enchantmentinstance);
                            continue;
                        }
                        itemstack2.m_41663_(enchantmentinstance.f_44947_, enchantmentinstance.f_44948_);
                    }
                    if (!p_39465_.m_150110_().f_35937_) {
                        itemstack1.m_41774_(i);
                        if (itemstack1.m_41619_()) {
                            this.enchantSlots.m_6836_(1, ItemStack.f_41583_);
                        }
                    }
                    p_39465_.m_36220_(Stats.f_12964_);
                    if (p_39465_ instanceof ServerPlayer) {
                        CriteriaTriggers.f_10575_.m_27668_((ServerPlayer)p_39465_, itemstack2, i);
                    }
                    this.enchantSlots.m_6596_();
                    this.enchantmentSeed.m_6422_(p_39465_.m_36322_());
                    this.m_6199_(this.enchantSlots);
                    p_39481_.m_5594_((Player)null, p_39482_, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, p_39481_.f_46441_.m_188501_() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        Util.m_143785_((String)(p_39465_.m_7755_() + " pressed invalid button id: " + p_39466_));
        return false;
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack p_39472_, int p_39473_, int p_39474_) {
        this.random.m_188584_((long)(this.enchantmentSeed.m_6501_() + p_39473_));
        List list = EnchantmentHelper.m_220297_((RandomSource)this.random, (ItemStack)p_39472_, (int)p_39474_, (boolean)false);
        if (p_39472_.m_150930_(Items.f_42517_) && list.size() > 1) {
            list.remove(this.random.m_188503_(list.size()));
        }
        return list;
    }

    public int getGoldCount() {
        ItemStack itemstack = this.enchantSlots.m_8020_(1);
        return itemstack.m_41619_() ? 0 : itemstack.m_41613_();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.m_6501_();
    }

    public void m_6877_(Player p_39488_) {
        super.m_6877_(p_39488_);
        this.access.m_39292_((p_39469_, p_39470_) -> this.m_150411_(p_39488_, this.enchantSlots));
    }

    public boolean m_6875_(Player p_39463_) {
        return AltarOfCorruptionMenu.m_38889_((ContainerLevelAccess)this.access, (Player)p_39463_, (Block)((Block)BlockRegistry.altarOfCorruption.get()));
    }

    public ItemStack m_7648_(Player p_39490_, int p_39491_) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(p_39491_);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (p_39491_ == 0) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (p_39491_ == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (itemstack1.m_204117_(Tags.Items.ENCHANTING_FUELS)) {
                if (!this.m_38903_(itemstack1, 1, 2, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (((Slot)this.f_38839_.get(0)).m_6657_() || !((Slot)this.f_38839_.get(0)).m_5857_(itemstack1)) {
                    return ItemStack.f_41583_;
                }
                ItemStack itemstack2 = itemstack1.m_255036_(1);
                itemstack1.m_41774_(1);
                ((Slot)this.f_38839_.get(0)).m_269060_(itemstack2);
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(p_39490_, itemstack1);
        }
        return itemstack;
    }
}

