/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.arcana.EntityRazorback;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelRazorback
extends EntityModel<EntityRazorback> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("razorback");
    public final ModelPart spine;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart tail;
    public final ModelPart rightFrontLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart leftHindLeg;

    public ModelRazorback(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.spine = root.m_171324_("spine");
        this.body = this.spine.m_171324_("body");
        this.head = this.spine.m_171324_("head");
        this.tail = this.spine.m_171324_("tail");
        this.rightFrontLeg = this.spine.m_171324_("right_front_leg");
        this.rightHindLeg = this.spine.m_171324_("right_hind_leg");
        this.leftFrontLeg = this.spine.m_171324_("left_front_leg");
        this.leftHindLeg = this.spine.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        PartDefinition spine = partdefinition.m_171599_("spine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)1.0f));
        spine.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(13, 23).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 3.0f, cubeDef).m_171514_(24, 13).m_171488_(-3.0f, -4.0f, -3.0f, 6.0f, 2.0f, 3.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-2.99f, (float)-3.99f));
        spine.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(26, 6).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 6.0f, cubeDef).m_171514_(26, 0).m_171488_(-4.0f, -0.01f, 0.0f, 8.0f, 0.0f, 6.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)4.0f));
        spine.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -3.0f, 8.0f, 5.0f, 8.0f, cubeDef).m_171514_(24, 18).m_171488_(-4.0f, -7.0f, 1.0f, 8.0f, 3.0f, 0.0f, cubeDef).m_171514_(0, 13).m_171488_(-4.0f, -7.0f, -3.0f, 8.0f, 2.0f, 8.0f, cubeDef).m_171514_(8, 26).m_171488_(0.0f, -11.0f, 0.0f, 1.0f, 6.0f, 1.0f, cubeDef).m_171514_(24, 30).m_171488_(2.0f, -8.0f, -2.0f, 1.0f, 3.0f, 1.0f, cubeDef).m_171514_(20, 30).m_171488_(-3.0f, -8.0f, 2.0f, 1.0f, 3.0f, 1.0f, cubeDef).m_171514_(12, 30).m_171488_(2.0f, -9.0f, 2.0f, 1.0f, 4.0f, 1.0f, cubeDef).m_171514_(16, 30).m_171488_(-3.0f, -9.0f, -2.0f, 1.0f, 4.0f, 1.0f, cubeDef).m_171514_(0, 15).m_171488_(0.0f, -8.0f, -4.0f, 0.0f, 3.0f, 8.0f, cubeDef).m_171514_(28, 15).m_171488_(0.01f, -8.0f, -4.0f, 0.0f, 3.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        spine.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)-2.0f));
        spine.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)-2.0f));
        spine.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)3.0f));
        spine.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(8.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(EntityRazorback entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) / 4.0f;
        float f1 = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f2 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.body.f_104205_ = f1 * 0.03f;
        this.rightHindLeg.f_104203_ = this.leftFrontLeg.f_104203_ = f1;
        this.leftHindLeg.f_104203_ = this.rightFrontLeg.f_104203_ = f2;
        this.tail.f_104204_ = f1 * 0.2f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.spine.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

