/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityLivestockMerchant;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelLivestockMerchant
extends EntityModel<EntityLivestockMerchant> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("livestock_merchant");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public ModelLivestockMerchant(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightarm = root.m_171324_("rightarm");
        this.leftarm = root.m_171324_("leftarm");
        this.rightleg = root.m_171324_("rightleg");
        this.leftleg = root.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 42).m_171480_().m_171488_(-7.0f, -8.0f, -7.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171480_().m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityLivestockMerchant entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.rightarm.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.rightleg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftleg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightleg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftleg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

