/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityShark;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelShark<T extends EntityShark>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("shark");
    private final ModelPart Spine;
    private final ModelPart flipperL;
    private final ModelPart flipperR;
    private final ModelPart tail;
    private final ModelPart Jaw;

    public ModelShark(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Jaw = root.m_171324_("Jaw");
        this.Spine = root.m_171324_("Spine");
        this.flipperL = root.m_171324_("LeftFinBone");
        this.flipperR = root.m_171324_("RightFinBone");
        this.tail = root.m_171324_("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Spine = partdefinition.m_171599_("Spine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)4.0f));
        Spine.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(34, 21).m_171488_(-5.0f, -0.5f, -8.8333f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, -6.5f, -15.8333f, 10.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-4.1667f));
        partdefinition.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(35, 0).m_171488_(-5.0f, -1.0f, -7.0f, 10.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-2.0f));
        PartDefinition Torso = Spine.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(71, -9).m_171488_(0.0f, -10.0f, -2.0f, 0.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 21).m_171488_(-6.0f, -5.0f, -4.0f, 12.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        partdefinition.m_171599_("RightFinBone", CubeListBuilder.m_171558_().m_171514_(47, 63).m_171488_(-6.5f, -1.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.5f, (float)18.0f, (float)1.5f));
        partdefinition.m_171599_("LeftFinBone", CubeListBuilder.m_171558_().m_171514_(47, 56).m_171488_(0.5f, -1.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)18.0f, (float)1.5f));
        Torso.m_171599_("Pelvis", CubeListBuilder.m_171558_().m_171514_(37, 36).m_171488_(-3.0f, -5.0f, -2.0f, 6.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)6.0f));
        PartDefinition Tail = partdefinition.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(17, 52).m_171488_(-2.0f, -3.25f, 0.75f, 4.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.75f, (float)10.25f));
        Tail.m_171599_("TailFin", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(0.0f, -9.5f, -2.0f, 0.0f, 17.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)8.75f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityShark entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.flipperL.f_104205_ = (float)(-Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.flipperR.f_104205_ = (float)(Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.tail.f_104204_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
    }

    public void prepareMobModel(T p_103621_, float p_103622_, float p_103623_, float p_103624_) {
        super.m_6839_(p_103621_, p_103622_, p_103623_, p_103624_);
        int l = ((EntityShark)((Object)p_103621_)).getAttackTick();
        this.Jaw.f_104203_ = l > 0 ? (l > 5 ? Mth.m_14031_((float)(((float)(-4 + l) - p_103624_) / 4.0f)) * (float)Math.PI * 0.4f : 0.15707964f * Mth.m_14031_((float)((float)Math.PI * ((float)l - p_103624_) / 10.0f))) : 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Jaw.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Spine.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.flipperL.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.flipperR.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

