/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityTheGrue;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelTheGrue
extends EntityModel<EntityTheGrue> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("the_grue");
    public final ModelPart Body;
    public final ModelPart Tail;
    public final ModelPart Head;
    public final ModelPart RightJaw;
    public final ModelPart LeftJaw;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelTheGrue(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Body = root.m_171324_("Body");
        this.Tail = this.Body.m_171324_("Tail");
        this.Head = this.Body.m_171324_("Head");
        this.LeftJaw = this.Head.m_171324_("LeftJaw");
        this.RightJaw = this.Head.m_171324_("RightJaw");
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubeDef = CubeDeformation.f_171458_;
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -3.0f, 0.0f, 10.0f, 14.0f, 15.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)15.0f));
        PartDefinition UpperTail = Tail.m_171599_("UpperTail", CubeListBuilder.m_171558_().m_171514_(64, 63).m_171488_(-3.0f, -4.0f, 0.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.f_171404_);
        PartDefinition MiddleTail = UpperTail.m_171599_("MiddleTail", CubeListBuilder.m_171558_().m_171514_(40, 63).m_171488_(-3.0f, -4.0f, 0.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        MiddleTail.m_171599_("LowerTail", CubeListBuilder.m_171558_().m_171514_(16, 63).m_171488_(-3.0f, -4.0f, 0.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(32, 29).m_171488_(-4.0f, -7.0f, -16.0f, 8.0f, 6.0f, 8.0f, cubeDef).m_171514_(0, 29).m_171488_(-4.0f, -7.0f, -8.0f, 8.0f, 11.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.01f));
        Head.m_171599_("RightJaw", CubeListBuilder.m_171558_().m_171514_(62, 35).m_171488_(-4.0f, -0.5f, -8.0f, 4.0f, 5.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-8.0f));
        Head.m_171599_("LeftJaw", CubeListBuilder.m_171558_().m_171514_(56, 17).m_171488_(0.0f, -0.5f, -8.0f, 4.0f, 5.0f, 8.0f, cubeDef), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-8.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(23, 43).m_171488_(-5.0f, -6.0f, -5.0f, 3.0f, 11.0f, 9.0f, cubeDef), PartPose.m_171419_((float)-2.99f, (float)7.99f, (float)7.0f));
        RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-1.5f, 0.0f, -3.0f, 5.0f, 11.0f, 6.0f, cubeDef), PartPose.m_171419_((float)-3.0f, (float)5.0f, (float)-2.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(47, 43).m_171488_(5.0f, -6.0f, -5.0f, 3.0f, 11.0f, 9.0f, cubeDef), PartPose.m_171419_((float)-0.01f, (float)7.99f, (float)7.0f));
        LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-3.5f, 0.0f, -3.0f, 5.0f, 11.0f, 6.0f, cubeDef), PartPose.m_171419_((float)6.0f, (float)5.0f, (float)-2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntityTheGrue entity, float p_103622_, float p_103623_, float p_103624_) {
        super.m_6839_((Entity)entity, p_103622_, p_103623_, p_103624_);
        int l = entity.getAttackTick();
        if (l > 0) {
            if (l > 5) {
                this.RightJaw.f_104203_ = this.RightJaw.f_104204_ = Mth.m_14031_((float)(((float)(-4 + l) - p_103624_) / 4.0f)) * (float)Math.PI * 0.4f + 0.1309f;
                this.LeftJaw.f_104203_ = this.RightJaw.f_104204_;
            } else {
                this.RightJaw.f_104203_ = this.RightJaw.f_104204_ = 0.1571f * Mth.m_14031_((float)((float)Math.PI * ((float)l - p_103624_) / 10.0f));
                this.LeftJaw.f_104203_ = this.RightJaw.f_104204_;
            }
        } else {
            this.RightJaw.f_104203_ = this.RightJaw.f_104204_ = Mth.m_14116_((float)((float)Math.atan(200.0f * p_103622_) / 3.0f)) * p_103623_ + 0.1309f;
            this.LeftJaw.f_104203_ = this.RightJaw.f_104204_;
        }
    }

    public void setupAnim(EntityTheGrue entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.LeftJaw.f_104204_ = -this.LeftJaw.f_104203_;
        float f = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        float f1 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.f_104205_ = f1 * 0.05f;
        this.Tail.f_104204_ = f * 0.4f;
        this.Tail.f_104203_ = f * 0.1f;
        this.RightLeg.f_104203_ = f * 1.4f;
        this.LeftLeg.f_104203_ = f1;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

