/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import divinerpg.effect.dimension.TwilightSky;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class IceikaSky
extends DimensionSpecialEffects {
    public static final ResourceLocation SUN_LOCATION = new ResourceLocation("divinerpg", "textures/particle/white_dwarf.png");
    public static final ResourceLocation MOON_LOCATION = new ResourceLocation("divinerpg", "textures/particle/ice_moon_phases.png");
    public static final ResourceLocation SNOW_LOCATION = new ResourceLocation("minecraft", "textures/environment/snow.png");
    public static final ResourceLocation HAIL_LOCATION = new ResourceLocation("divinerpg", "textures/environment/hail.png");
    public static final ResourceLocation BONEYARD_LOCATION = new ResourceLocation("divinerpg", "boneyard");
    @Nullable
    private VertexBuffer skyBuffer;
    @Nullable
    private VertexBuffer starBuffer;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private boolean isRaining = false;
    private boolean isBoneyard = false;
    private boolean isBlizzard = false;
    private int lastTick;

    public IceikaSky() {
        super(256.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = TwilightSky.drawStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
        tesselator = Tesselator.m_85913_();
        bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        bufferbuilder$renderedbuffer = TwilightSky.buildSkyDisc(bufferbuilder, 16.0f);
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        float f = level.m_46722_(partialTick);
        if (f > 0.0f) {
            lightTexture.m_109896_();
            int i = Mth.m_14107_((double)camX);
            int j = Mth.m_14107_((double)camY);
            int k = Mth.m_14107_((double)camZ);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int l = Minecraft.m_91405_() ? 10 : 5;
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)ticks + partialTick;
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    double z;
                    double y;
                    double x;
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainSizeX[l1] * 0.5;
                    double d1 = (double)this.rainSizeZ[l1] * 0.5;
                    blockpos$mutableblockpos.m_122169_((double)k1, camY, (double)j1);
                    Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                    if (biome.m_264600_((BlockPos)blockpos$mutableblockpos) == Biome.Precipitation.NONE) continue;
                    int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    RandomSource randomsource = RandomSource.m_216335_((long)(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761));
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    byte precipitationType = Utils.ICEIKA_WEATHER;
                    if (precipitationType == 0) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATION);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        float f5 = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                        float f6 = (float)(randomsource.m_188500_() + (double)f1 * 0.01 * randomsource.m_188583_());
                        float f7 = (float)(randomsource.m_188500_() + (double)f1 * randomsource.m_188583_() * 0.001);
                        double d3 = (double)k1 + 0.5 - camX;
                        double d5 = (double)j1 + 0.5 - camZ;
                        float f8 = (float)(Math.sqrt(d3 * d3 + d5 * d5) / (double)l);
                        float f9 = ((1.0f - f8 * f8) * 0.3f + 0.5f) * f;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        int l3 = k3 >> 16 & 0xFFFF;
                        int i4 = k3 & 0xFFFF;
                        int j4 = (l3 * 3 + 240) / 4;
                        int k4 = (i4 * 3 + 240) / 4;
                        bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)k2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)k2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)j2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f + f6, (float)k2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)j2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f + f6, (float)k2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        continue;
                    }
                    if (precipitationType == 1) {
                        if (i1 != 1) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 1;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HAIL_LOCATION);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f2 = -((float)i3 + partialTick) / 32.0f * (3.0f + randomsource.m_188501_());
                        double d2 = (double)k1 + 0.5 - camX;
                        double d4 = (double)j1 + 0.5 - camZ;
                        float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)k2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)k2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)j2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)j2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                        continue;
                    }
                    if (precipitationType != 2 || this.lastTick == ticks || Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL || !randomsource.m_188499_() || !level.m_45527_(new BlockPos((int)(x = camX + Math.random() * 38.0 - 19.0), (int)(y = camY + Math.random() * 16.0 - 8.0), (int)(z = camZ + Math.random() * 32.0 - 16.0)))) continue;
                    this.isBlizzard = true;
                    level.m_6493_((ParticleOptions)ParticleTypes.f_175821_, true, x, y, z, 0.5, 0.1, 0.0);
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.m_109891_();
        }
        this.lastTick = ticks;
        return true;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        return true;
    }

    public Vec3 m_5927_(Vec3 vec, float f) {
        return vec.m_82542_((double)f * 0.94 + 0.06, (double)f * 0.94 + 0.06, (double)f * 0.91 + 0.09);
    }

    public boolean m_5781_(int x, int y) {
        return y < 128 && this.isRaining || this.isBoneyard;
    }

    @Nullable
    public float[] m_7518_(float f, float ff) {
        float[] color = super.m_7518_(f, ff);
        if (color == null) {
            return null;
        }
        return new float[]{color[0] * 0.2f, color[1] * 0.9f, color[2], color[3]};
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        if (this.isBlizzard && Utils.ICEIKA_WEATHER != 2 && level.m_45527_(camera.m_90588_())) {
            this.isBlizzard = false;
            level.m_245747_(camera.m_90588_(), (SoundEvent)SoundRegistry.SNOWFLAKES_AFTER_BLIZZARD.get(), SoundSource.MUSIC, 0.2f, 1.0f, false);
        }
        this.isRaining = level.m_46471_();
        this.isBoneyard = level.m_204166_(camera.m_90588_()).m_203373_(BONEYARD_LOCATION);
        setupFog.run();
        if (!isFoggy && (fogtype = camera.m_167685_()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !TwilightSky.doesMobEffectBlockSky(camera)) {
            Vec3 vec3 = level.m_171660_(camera.m_90583_(), partialTick);
            float f = (float)(vec3.f_82479_ * 0.1);
            float f1 = (float)(vec3.f_82480_ * 0.1);
            float f2 = (float)(vec3.f_82481_ * 0.17);
            FogRenderer.m_109036_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            ShaderInstance shaderinstance = RenderSystem.getShader();
            this.skyBuffer.m_85921_();
            this.skyBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] afloat = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
            if (afloat != null) {
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                float f3 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
                poseStack.m_252781_(Axis.f_252403_.m_252977_(f3));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                float f4 = afloat[0];
                float f5 = afloat[1];
                float f6 = afloat[2];
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)((double)j * (Math.PI * 2) / 16.0);
                    float f8 = Mth.m_14031_((float)f7);
                    float f9 = Mth.m_14089_((float)f7);
                    bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                poseStack.m_85849_();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            float f11 = 1.0f - level.m_46722_(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTick) * 360.0f));
            Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
            float f12 = 30.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            f12 = 20.0f;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
            int k = level.m_46941_();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)l / 4.0f;
            float f14 = (float)i1 / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f16 = (float)(i1 + 1) / 2.0f;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            float f10 = level.m_104811_(partialTick) * f11 + 0.5f;
            RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            this.starBuffer.m_85921_();
            this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            setupFog.run();
            RenderSystem.setShaderColor((float)0.82f, (float)(0.85f + (afloat == null ? 0.0f : afloat[1] * 1.84f) * (0.398f - Math.abs(Mth.m_14089_((float)(level.m_46942_(partialTick) * ((float)Math.PI * 2)))))), (float)(0.92f + f2 * 1.4f), (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }
}

