/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class AISunstormAttack
extends Goal {
    private final Mob entityHost;
    private final RangedAttackMob rangedAttackEntityHost;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public AISunstormAttack(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
    }

    public AISunstormAttack(RangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
        if (!(attacker instanceof Mob)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = attacker;
        this.entityHost = (Mob)attacker;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
    }

    public boolean shouldExecute() {
        LivingEntity entitylivingbase = this.entityHost.m_5448_();
        if (entitylivingbase == null) {
            return false;
        }
        double distance = this.entityHost.m_20275_(entitylivingbase.f_19854_, entitylivingbase.m_20191_().f_82289_, entitylivingbase.f_19856_);
        if (distance < 4.0 || entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean m_8036_() {
        return this.shouldExecute() || !this.entityHost.m_21573_().m_26571_();
    }

    public boolean m_8045_() {
        return this.shouldExecute() || !this.entityHost.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void m_8037_() {
        if (this.entityHost != null && this.attackTarget != null) {
            double d0 = this.entityHost.m_20275_(this.attackTarget.f_19854_, this.attackTarget.m_20191_().f_82289_, this.attackTarget.f_19856_);
            boolean flag = this.entityHost.m_142582_((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entityHost.m_21573_().m_26573_();
            } else {
                this.entityHost.m_21573_().m_5624_((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = Mth.m_14116_((float)((float)d0)) / this.attackRadius;
                float lvt_5_1_ = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackEntityHost.m_6504_(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = Mth.m_14116_((float)((float)d0)) / this.attackRadius;
                this.rangedAttackTime = Mth.m_14143_((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }
}

